/*
 * Decompiled with CFR 0.152.
 */
package me.mnedokushev.zio.apache.arrow.core.codec;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.UUID;
import me.mnedokushev.zio.apache.arrow.core.codec.EncoderError$;
import me.mnedokushev.zio.apache.arrow.core.codec.ValueEncoder;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.BigIntWriter;
import org.apache.arrow.vector.complex.writer.BitWriter;
import org.apache.arrow.vector.complex.writer.DecimalWriter;
import org.apache.arrow.vector.complex.writer.FieldWriter;
import org.apache.arrow.vector.complex.writer.Float4Writer;
import org.apache.arrow.vector.complex.writer.Float8Writer;
import org.apache.arrow.vector.complex.writer.IntWriter;
import org.apache.arrow.vector.complex.writer.LargeVarBinaryWriter;
import org.apache.arrow.vector.complex.writer.SmallIntWriter;
import org.apache.arrow.vector.complex.writer.UInt1Writer;
import org.apache.arrow.vector.complex.writer.UInt2Writer;
import org.apache.arrow.vector.complex.writer.VarBinaryWriter;
import org.apache.arrow.vector.complex.writer.VarCharWriter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import zio.Chunk;
import zio.Zippable$;
import zio.schema.Schema;
import zio.schema.StandardType;

public final class ValueEncoder$
implements Serializable {
    public static final ValueEncoder$ MODULE$ = new ValueEncoder$();

    private ValueEncoder$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ValueEncoder$.class);
    }

    public <A> void encodeStruct(A value, Chunk<Schema.Field<A, ?>> fields, Chunk<ValueEncoder<?>> encoders, FieldWriter writer, BufferAllocator alloc) {
        writer.start();
        fields.zip(encoders, Zippable$.MODULE$.Zippable2()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Some some;
            Schema.Field field;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null && (field = (Schema.Field)tuple2._1()) instanceof Schema.Field && !(some = Schema.Field$.MODULE$.unapply(field)).isEmpty()) {
                Tuple6 tuple6 = (Tuple6)some.get();
                String name = (String)tuple6._1();
                Function1 get = (Function1)tuple6._5();
                ValueEncoder encoder = (ValueEncoder)tuple2._2();
                this.encodeValue0$1(encoder, value, get, (Option)Some$.MODULE$.apply((Object)name), writer, alloc);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        writer.end();
    }

    public <A> void encodeList(Chunk<A> chunk, ValueEncoder<A> encoder, FieldWriter writer, BufferAllocator alloc) {
        Iterator it = chunk.iterator();
        writer.startList();
        it.foreach((Function1)(JProcedure1 & Serializable)_$1 -> encoder.encodeValue(_$1, (Option<String>)None$.MODULE$, writer, alloc));
        writer.endList();
    }

    public <A> void encodePrimitive0(boolean nested, StandardType<A> standardType, A value, FieldWriter writer, Option<String> name, BufferAllocator alloc) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(standardType, value);
        if (tuple2 != null) {
            StandardType standardType2 = (StandardType)tuple2._1();
            Object object = tuple2._2();
            if (StandardType.StringType$.MODULE$.equals(standardType2) && object instanceof String) {
                String v = (String)object;
                this.writeString$1(writer, alloc, nested, name, v);
                return;
            }
            if (StandardType.BoolType$.MODULE$.equals(standardType2) && object instanceof Boolean) {
                boolean v = BoxesRunTime.unboxToBoolean((Object)object);
                ((BitWriter)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$1(writer), (Function1 & Serializable)x$0 -> writer.bit(x$0))).writeBit(v ? 1 : 0);
                return;
            }
            if (StandardType.ByteType$.MODULE$.equals(standardType2) && object instanceof Byte) {
                byte v = BoxesRunTime.unboxToByte((Object)object);
                ((UInt1Writer)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$3(writer), (Function1 & Serializable)x$0 -> writer.uInt1(x$0))).writeUInt1(v);
                return;
            }
            if (StandardType.ShortType$.MODULE$.equals(standardType2) && object instanceof Short) {
                short v = BoxesRunTime.unboxToShort((Object)object);
                ((SmallIntWriter)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$5(writer), (Function1 & Serializable)x$0 -> writer.smallInt(x$0))).writeSmallInt(v);
                return;
            }
            if (StandardType.IntType$.MODULE$.equals(standardType2) && object instanceof Integer) {
                int v = BoxesRunTime.unboxToInt((Object)object);
                ((IntWriter)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$7(writer), (Function1 & Serializable)x$0 -> writer.integer(x$0))).writeInt(v);
                return;
            }
            if (StandardType.LongType$.MODULE$.equals(standardType2) && object instanceof Long) {
                long v = BoxesRunTime.unboxToLong((Object)object);
                ((BigIntWriter)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$9(writer), (Function1 & Serializable)x$0 -> writer.bigInt(x$0))).writeBigInt(v);
                return;
            }
            if (StandardType.FloatType$.MODULE$.equals(standardType2) && object instanceof Float) {
                float v = BoxesRunTime.unboxToFloat((Object)object);
                ((Float4Writer)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$11(writer), (Function1 & Serializable)x$0 -> writer.float4(x$0))).writeFloat4(v);
                return;
            }
            if (StandardType.DoubleType$.MODULE$.equals(standardType2) && object instanceof Double) {
                double v = BoxesRunTime.unboxToDouble((Object)object);
                ((Float8Writer)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$13(writer), (Function1 & Serializable)x$0 -> writer.float8(x$0))).writeFloat8(v);
                return;
            }
            if (StandardType.BinaryType$.MODULE$.equals(standardType2) && object instanceof Chunk) {
                Chunk v = (Chunk)object;
                this.withBuffer$1(alloc, v.length(), (Function1)(JProcedure1 & Serializable)buffer -> {
                    buffer.writeBytes((byte[])v.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
                    ((LargeVarBinaryWriter)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$15$$anonfun$1(writer), (Function1 & Serializable)x$0 -> writer.largeVarBinary(x$0))).writeLargeVarBinary(0L, (long)v.length(), buffer);
                });
                return;
            }
            if (StandardType.CharType$.MODULE$.equals(standardType2) && object instanceof Character) {
                char v = BoxesRunTime.unboxToChar((Object)object);
                ((UInt2Writer)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$16(writer), (Function1 & Serializable)x$0 -> writer.uInt2(x$0))).writeUInt2(v);
                return;
            }
            if (StandardType.UUIDType$.MODULE$.equals(standardType2) && object instanceof UUID) {
                UUID v = (UUID)object;
                this.withBuffer$1(alloc, 16L, (Function1)(JProcedure1 & Serializable)buffer -> {
                    buffer.writeLong(v.getMostSignificantBits());
                    buffer.writeLong(v.getLeastSignificantBits());
                    ((VarBinaryWriter)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$18$$anonfun$1(writer), (Function1 & Serializable)x$0 -> writer.varBinary(x$0))).writeVarBinary(0, 16, buffer);
                });
                return;
            }
            if (StandardType.BigDecimalType$.MODULE$.equals(standardType2) && object instanceof BigDecimal) {
                BigDecimal v = (BigDecimal)object;
                ((DecimalWriter)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$19(writer), (Function1 & Serializable)x$0 -> writer.decimal(x$0))).writeDecimal(v);
                return;
            }
            if (StandardType.BigIntegerType$.MODULE$.equals(standardType2) && object instanceof BigInteger) {
                BigInteger v = (BigInteger)object;
                byte[] bb = v.toByteArray();
                this.withBuffer$1(alloc, bb.length, (Function1)(JProcedure1 & Serializable)buffer -> {
                    buffer.writeBytes(bb);
                    ((VarBinaryWriter)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$21$$anonfun$1(writer), (Function1 & Serializable)x$0 -> writer.varBinary(x$0))).writeVarBinary(0, bb.length, buffer);
                });
                return;
            }
            if (StandardType.DayOfWeekType$.MODULE$.equals(standardType2) && object instanceof DayOfWeek) {
                DayOfWeek v = (DayOfWeek)object;
                ((IntWriter)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$22(writer), (Function1 & Serializable)x$0 -> writer.integer(x$0))).writeInt(v.getValue());
                return;
            }
            if (StandardType.MonthType$.MODULE$.equals(standardType2) && object instanceof Month) {
                Month v = (Month)object;
                ((IntWriter)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$24(writer), (Function1 & Serializable)x$0 -> writer.integer(x$0))).writeInt(v.getValue());
                return;
            }
            if (StandardType.MonthDayType$.MODULE$.equals(standardType2) && object instanceof MonthDay) {
                MonthDay v = (MonthDay)object;
                this.writeLong$1(writer, alloc, nested, name, v, (Function1 & Serializable)_$2 -> _$2.getDayOfMonth(), (Function1 & Serializable)_$3 -> _$3.getMonthValue());
                return;
            }
            if (StandardType.PeriodType$.MODULE$.equals(standardType2) && object instanceof Period) {
                Period v = (Period)object;
                this.withBuffer$1(alloc, 12L, (Function1)(JProcedure1 & Serializable)buffer -> {
                    buffer.writeInt(v.getDays());
                    buffer.writeInt(v.getMonths());
                    buffer.writeInt(v.getYears());
                    ((VarBinaryWriter)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$28$$anonfun$1(writer), (Function1 & Serializable)x$0 -> writer.varBinary(x$0))).writeVarBinary(0, 12, buffer);
                });
                return;
            }
            if (StandardType.YearType$.MODULE$.equals(standardType2) && object instanceof Year) {
                Year v = (Year)object;
                ((IntWriter)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$29(writer), (Function1 & Serializable)x$0 -> writer.integer(x$0))).writeInt(v.getValue());
                return;
            }
            if (StandardType.YearMonthType$.MODULE$.equals(standardType2) && object instanceof YearMonth) {
                YearMonth v = (YearMonth)object;
                this.writeLong$1(writer, alloc, nested, name, v, (Function1 & Serializable)_$4 -> _$4.getMonthValue(), (Function1 & Serializable)_$5 -> _$5.getYear());
                return;
            }
            if (StandardType.ZoneIdType$.MODULE$.equals(standardType2) && object instanceof ZoneId) {
                ZoneId v = (ZoneId)object;
                this.writeString$1(writer, alloc, nested, name, v.toString());
                return;
            }
            if (StandardType.ZoneOffsetType$.MODULE$.equals(standardType2) && object instanceof ZoneOffset) {
                ZoneOffset v = (ZoneOffset)object;
                this.writeString$1(writer, alloc, nested, name, v.toString());
                return;
            }
            if (StandardType.DurationType$.MODULE$.equals(standardType2) && object instanceof Duration) {
                Duration v = (Duration)object;
                ((BigIntWriter)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$33(writer), (Function1 & Serializable)x$0 -> writer.bigInt(x$0))).writeBigInt(v.toMillis());
                return;
            }
            if (StandardType.InstantType$.MODULE$.equals(standardType2) && object instanceof Instant) {
                Instant v = (Instant)object;
                ((BigIntWriter)this.resolveWriter$1(nested, name, writer, () -> ValueEncoder$.encodePrimitive0$$anonfun$35(writer), (Function1 & Serializable)x$0 -> writer.bigInt(x$0))).writeBigInt(v.toEpochMilli());
                return;
            }
            if (StandardType.LocalDateType$.MODULE$.equals(standardType2) && object instanceof LocalDate) {
                LocalDate v = (LocalDate)object;
                this.writeString$1(writer, alloc, nested, name, v.toString());
                return;
            }
            if (StandardType.LocalTimeType$.MODULE$.equals(standardType2) && object instanceof LocalTime) {
                LocalTime v = (LocalTime)object;
                this.writeString$1(writer, alloc, nested, name, v.toString());
                return;
            }
            if (StandardType.LocalDateTimeType$.MODULE$.equals(standardType2) && object instanceof LocalDateTime) {
                LocalDateTime v = (LocalDateTime)object;
                this.writeString$1(writer, alloc, nested, name, v.toString());
                return;
            }
            if (StandardType.OffsetTimeType$.MODULE$.equals(standardType2) && object instanceof OffsetTime) {
                OffsetTime v = (OffsetTime)object;
                this.writeString$1(writer, alloc, nested, name, v.toString());
                return;
            }
            if (StandardType.OffsetDateTimeType$.MODULE$.equals(standardType2) && object instanceof OffsetDateTime) {
                OffsetDateTime v = (OffsetDateTime)object;
                this.writeString$1(writer, alloc, nested, name, v.toString());
                return;
            }
            if (StandardType.ZonedDateTimeType$.MODULE$.equals(standardType2) && object instanceof ZonedDateTime) {
                ZonedDateTime v = (ZonedDateTime)object;
                this.writeString$1(writer, alloc, nested, name, v.toString());
                return;
            }
            StandardType other = standardType2;
            throw EncoderError$.MODULE$.apply(new StringBuilder(36).append("Unsupported ZIO Schema StandardType ").append(other).toString(), EncoderError$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError((Object)tuple2);
    }

    public <A> void encodePrimitive(StandardType<A> standardType, A value, Option<String> name, FieldWriter writer, BufferAllocator alloc) {
        this.encodePrimitive0(true, standardType, value, writer, name, alloc);
    }

    public <A> void encodePrimitive(StandardType<A> standardType, A value, FieldWriter writer, BufferAllocator alloc) {
        this.encodePrimitive0(false, standardType, value, writer, (Option<String>)None$.MODULE$, alloc);
    }

    private final void encodeValue0$1(ValueEncoder encoder, Object value, Function1 get, Option name, FieldWriter writer, BufferAllocator alloc) {
        encoder.encodeValue(get.apply(value), (Option<String>)name, writer, alloc);
    }

    private final BaseWriter resolveWriter$1(boolean nested$1, Option name$1, FieldWriter writer$3, Function0 f1, Function1 f2) {
        if (nested$1) {
            return (BaseWriter)name$1.fold(f1, f2);
        }
        return writer$3;
    }

    private final void withBuffer$1(BufferAllocator alloc$3, long size, Function1 fn) {
        ArrowBuf buffer = alloc$3.buffer(size);
        fn.apply((Object)buffer);
        buffer.close();
    }

    private static final VarCharWriter writeString$1$$anonfun$1$$anonfun$1(FieldWriter writer$6) {
        return writer$6.varChar();
    }

    private final void writeString$1(FieldWriter writer$5, BufferAllocator alloc$4, boolean nested$3, Option name$3, String s) {
        this.withBuffer$1(alloc$4, s.length(), (Function1)(JProcedure1 & Serializable)buffer -> {
            buffer.writeBytes(s.getBytes(StandardCharsets.UTF_8));
            ((VarCharWriter)this.resolveWriter$1(nested$3, name$3, writer$5, () -> ValueEncoder$.writeString$1$$anonfun$1$$anonfun$1(writer$5), (Function1 & Serializable)x$0 -> writer$5.varChar(x$0))).writeVarChar(0, s.length(), buffer);
        });
    }

    private static final BigIntWriter writeLong$1$$anonfun$1$$anonfun$1(FieldWriter writer$10) {
        return writer$10.bigInt();
    }

    private final void writeLong$1(FieldWriter writer$9, BufferAllocator alloc$5, boolean nested$5, Option name$5, Object v, Function1 fst, Function1 snd) {
        this.withBuffer$1(alloc$5, 8L, (Function1)(JProcedure1 & Serializable)buffer -> {
            buffer.writeInt(BoxesRunTime.unboxToInt((Object)fst.apply(v)));
            buffer.writeInt(BoxesRunTime.unboxToInt((Object)snd.apply(v)));
            ((BigIntWriter)this.resolveWriter$1(nested$5, name$5, writer$9, () -> ValueEncoder$.writeLong$1$$anonfun$1$$anonfun$1(writer$9), (Function1 & Serializable)x$0 -> writer$9.bigInt(x$0))).writeBigInt(buffer.getLong(0L));
        });
    }

    private static final BitWriter encodePrimitive0$$anonfun$1(FieldWriter writer$12) {
        return writer$12.bit();
    }

    private static final UInt1Writer encodePrimitive0$$anonfun$3(FieldWriter writer$14) {
        return writer$14.uInt1();
    }

    private static final SmallIntWriter encodePrimitive0$$anonfun$5(FieldWriter writer$16) {
        return writer$16.smallInt();
    }

    private static final IntWriter encodePrimitive0$$anonfun$7(FieldWriter writer$18) {
        return writer$18.integer();
    }

    private static final BigIntWriter encodePrimitive0$$anonfun$9(FieldWriter writer$20) {
        return writer$20.bigInt();
    }

    private static final Float4Writer encodePrimitive0$$anonfun$11(FieldWriter writer$22) {
        return writer$22.float4();
    }

    private static final Float8Writer encodePrimitive0$$anonfun$13(FieldWriter writer$24) {
        return writer$24.float8();
    }

    private static final LargeVarBinaryWriter encodePrimitive0$$anonfun$15$$anonfun$1(FieldWriter writer$27) {
        return writer$27.largeVarBinary();
    }

    private static final UInt2Writer encodePrimitive0$$anonfun$16(FieldWriter writer$29) {
        return writer$29.uInt2();
    }

    private static final VarBinaryWriter encodePrimitive0$$anonfun$18$$anonfun$1(FieldWriter writer$32) {
        return writer$32.varBinary();
    }

    private static final DecimalWriter encodePrimitive0$$anonfun$19(FieldWriter writer$34) {
        return writer$34.decimal();
    }

    private static final VarBinaryWriter encodePrimitive0$$anonfun$21$$anonfun$1(FieldWriter writer$37) {
        return writer$37.varBinary();
    }

    private static final IntWriter encodePrimitive0$$anonfun$22(FieldWriter writer$39) {
        return writer$39.integer();
    }

    private static final IntWriter encodePrimitive0$$anonfun$24(FieldWriter writer$41) {
        return writer$41.integer();
    }

    private static final VarBinaryWriter encodePrimitive0$$anonfun$28$$anonfun$1(FieldWriter writer$44) {
        return writer$44.varBinary();
    }

    private static final IntWriter encodePrimitive0$$anonfun$29(FieldWriter writer$46) {
        return writer$46.integer();
    }

    private static final BigIntWriter encodePrimitive0$$anonfun$33(FieldWriter writer$48) {
        return writer$48.bigInt();
    }

    private static final BigIntWriter encodePrimitive0$$anonfun$35(FieldWriter writer$50) {
        return writer$50.bigInt();
    }
}

