/*
 * Decompiled with CFR 0.152.
 */
package me.mnedokushev.zio.apache.arrow.core.codec;

import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.UUID;
import me.mnedokushev.zio.apache.arrow.core.codec.DecoderError;
import me.mnedokushev.zio.apache.arrow.core.codec.DecoderError$;
import me.mnedokushev.zio.apache.arrow.core.codec.ValueDecoder;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.reader.FieldReader;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.Duration$;
import zio.Zippable$;
import zio.schema.DynamicValue;
import zio.schema.Schema;
import zio.schema.StandardType;
import zio.schema.TypeId;

public final class ValueDecoder$ {
    public static final ValueDecoder$ MODULE$ = new ValueDecoder$();

    public <V0 extends ValueVector, A> DynamicValue decodeStruct(Chunk<Schema.Field<A, ?>> fields, Chunk<ValueDecoder<?>> decoders, FieldReader reader, V0 vec, int idx) {
        ListMap values = (ListMap)ListMap$.MODULE$.apply((Seq)fields.zip(decoders, Zippable$.MODULE$.Zippable2()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Schema.Field field = (Schema.Field)tuple2._1();
                ValueDecoder decoder = (ValueDecoder)tuple2._2();
                DynamicValue value = decoder.decodeValue((Option<String>)new Some((Object)field.name()), reader, vec, idx);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name().toString()), (Object)value);
            }
            throw new MatchError((Object)tuple2);
        }));
        return new DynamicValue.Record((TypeId)TypeId.Structural$.MODULE$, values);
    }

    public <V0 extends ValueVector, A> DynamicValue decodeList(ValueDecoder<A> decoder, FieldReader reader, V0 vec, int idx) {
        ChunkBuilder builder = ChunkBuilder$.MODULE$.make();
        int idx0 = idx;
        while (reader.next()) {
            builder.addOne((Object)decoder.decodeValue((Option<String>)None$.MODULE$, reader, vec, idx0));
            ++idx0;
        }
        return new DynamicValue.Sequence((Chunk)builder.result());
    }

    public <A> DynamicValue decodePrimitive(StandardType<A> standardType, FieldReader reader) {
        StandardType<A> standardType2 = standardType;
        if (standardType2 == StandardType.StringType$.MODULE$) {
            StandardType.StringType$ stringType$ = (StandardType.StringType$)standardType2;
            return new DynamicValue.Primitive((Object)reader.readText().toString(), (StandardType)stringType$);
        }
        if (standardType2 == StandardType.BoolType$.MODULE$) {
            StandardType.BoolType$ boolType$ = (StandardType.BoolType$)standardType2;
            return new DynamicValue.Primitive((Object)BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(reader.readBoolean())), (StandardType)boolType$);
        }
        if (standardType2 == StandardType.ByteType$.MODULE$) {
            StandardType.ByteType$ byteType$ = (StandardType.ByteType$)standardType2;
            return new DynamicValue.Primitive((Object)BoxesRunTime.boxToByte((byte)Predef$.MODULE$.Byte2byte(reader.readByte())), (StandardType)byteType$);
        }
        if (standardType2 == StandardType.ShortType$.MODULE$) {
            StandardType.ShortType$ shortType$ = (StandardType.ShortType$)standardType2;
            return new DynamicValue.Primitive((Object)BoxesRunTime.boxToShort((short)Predef$.MODULE$.Short2short(reader.readShort())), (StandardType)shortType$);
        }
        if (standardType2 == StandardType.IntType$.MODULE$) {
            StandardType.IntType$ intType$ = (StandardType.IntType$)standardType2;
            return new DynamicValue.Primitive((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(reader.readInteger())), (StandardType)intType$);
        }
        if (standardType2 == StandardType.LongType$.MODULE$) {
            StandardType.LongType$ longType$ = (StandardType.LongType$)standardType2;
            return new DynamicValue.Primitive((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(reader.readLong())), (StandardType)longType$);
        }
        if (standardType2 == StandardType.FloatType$.MODULE$) {
            StandardType.FloatType$ floatType$ = (StandardType.FloatType$)standardType2;
            return new DynamicValue.Primitive((Object)BoxesRunTime.boxToFloat((float)Predef$.MODULE$.Float2float(reader.readFloat())), (StandardType)floatType$);
        }
        if (standardType2 == StandardType.DoubleType$.MODULE$) {
            StandardType.DoubleType$ doubleType$ = (StandardType.DoubleType$)standardType2;
            return new DynamicValue.Primitive((Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(reader.readDouble())), (StandardType)doubleType$);
        }
        if (standardType2 == StandardType.BinaryType$.MODULE$) {
            StandardType.BinaryType$ binaryType$ = (StandardType.BinaryType$)standardType2;
            return new DynamicValue.Primitive((Object)Chunk$.MODULE$.fromArray((Object)reader.readByteArray()), (StandardType)binaryType$);
        }
        if (standardType2 == StandardType.CharType$.MODULE$) {
            StandardType.CharType$ charType$ = (StandardType.CharType$)standardType2;
            return new DynamicValue.Primitive((Object)BoxesRunTime.boxToCharacter((char)Predef$.MODULE$.Character2char(reader.readCharacter())), (StandardType)charType$);
        }
        if (standardType2 == StandardType.UUIDType$.MODULE$) {
            StandardType.UUIDType$ uUIDType$ = (StandardType.UUIDType$)standardType2;
            ByteBuffer bb = ByteBuffer.wrap(reader.readByteArray());
            return new DynamicValue.Primitive((Object)new UUID(bb.getLong(0), bb.getLong(8)), (StandardType)uUIDType$);
        }
        if (standardType2 == StandardType.BigDecimalType$.MODULE$) {
            StandardType.BigDecimalType$ bigDecimalType$ = (StandardType.BigDecimalType$)standardType2;
            return new DynamicValue.Primitive((Object)reader.readBigDecimal(), (StandardType)bigDecimalType$);
        }
        if (standardType2 == StandardType.BigIntegerType$.MODULE$) {
            StandardType.BigIntegerType$ bigIntegerType$ = (StandardType.BigIntegerType$)standardType2;
            return new DynamicValue.Primitive((Object)new BigInteger(reader.readByteArray()), (StandardType)bigIntegerType$);
        }
        if (standardType2 == StandardType.DayOfWeekType$.MODULE$) {
            StandardType.DayOfWeekType$ dayOfWeekType$ = (StandardType.DayOfWeekType$)standardType2;
            return new DynamicValue.Primitive((Object)DayOfWeek.of(Predef$.MODULE$.Integer2int(reader.readInteger())), (StandardType)dayOfWeekType$);
        }
        if (standardType2 == StandardType.MonthType$.MODULE$) {
            StandardType.MonthType$ monthType$ = (StandardType.MonthType$)standardType2;
            return new DynamicValue.Primitive((Object)Month.of(Predef$.MODULE$.Integer2int(reader.readInteger())), (StandardType)monthType$);
        }
        if (standardType2 == StandardType.MonthDayType$.MODULE$) {
            StandardType.MonthDayType$ monthDayType$ = (StandardType.MonthDayType$)standardType2;
            ByteBuffer bb = ByteBuffer.allocate(8).putLong(Predef$.MODULE$.Long2long(reader.readLong()));
            return new DynamicValue.Primitive((Object)MonthDay.of(bb.getInt(0), bb.getInt(4)), (StandardType)monthDayType$);
        }
        if (standardType2 == StandardType.PeriodType$.MODULE$) {
            StandardType.PeriodType$ periodType$ = (StandardType.PeriodType$)standardType2;
            ByteBuffer bb = ByteBuffer.wrap(reader.readByteArray());
            return new DynamicValue.Primitive((Object)Period.of(bb.getInt(0), bb.getInt(4), bb.getInt(8)), (StandardType)periodType$);
        }
        if (standardType2 == StandardType.YearType$.MODULE$) {
            StandardType.YearType$ yearType$ = (StandardType.YearType$)standardType2;
            return new DynamicValue.Primitive((Object)Year.of(Predef$.MODULE$.Integer2int(reader.readInteger())), (StandardType)yearType$);
        }
        if (standardType2 == StandardType.YearMonthType$.MODULE$) {
            StandardType.YearMonthType$ yearMonthType$ = (StandardType.YearMonthType$)standardType2;
            ByteBuffer bb = ByteBuffer.allocate(8).putLong(Predef$.MODULE$.Long2long(reader.readLong()));
            return new DynamicValue.Primitive((Object)YearMonth.of(bb.getInt(0), bb.getInt(4)), (StandardType)yearMonthType$);
        }
        if (standardType2 == StandardType.ZoneIdType$.MODULE$) {
            StandardType.ZoneIdType$ zoneIdType$ = (StandardType.ZoneIdType$)standardType2;
            return new DynamicValue.Primitive((Object)ZoneId.of(reader.readText().toString()), (StandardType)zoneIdType$);
        }
        if (standardType2 == StandardType.ZoneOffsetType$.MODULE$) {
            StandardType.ZoneOffsetType$ zoneOffsetType$ = (StandardType.ZoneOffsetType$)standardType2;
            return new DynamicValue.Primitive((Object)ZoneOffset.of(reader.readText().toString()), (StandardType)zoneOffsetType$);
        }
        if (standardType2 == StandardType.DurationType$.MODULE$) {
            StandardType.DurationType$ durationType$ = (StandardType.DurationType$)standardType2;
            return new DynamicValue.Primitive((Object)Duration$.MODULE$.fromMillis(Predef$.MODULE$.Long2long(reader.readLong())), (StandardType)durationType$);
        }
        if (standardType2 == StandardType.InstantType$.MODULE$) {
            StandardType.InstantType$ instantType$ = (StandardType.InstantType$)standardType2;
            return new DynamicValue.Primitive((Object)Instant.ofEpochMilli(Predef$.MODULE$.Long2long(reader.readLong())), (StandardType)instantType$);
        }
        if (standardType2 == StandardType.LocalDateType$.MODULE$) {
            StandardType.LocalDateType$ localDateType$ = (StandardType.LocalDateType$)standardType2;
            return new DynamicValue.Primitive((Object)LocalDate.parse(reader.readText().toString()), (StandardType)localDateType$);
        }
        if (standardType2 == StandardType.LocalTimeType$.MODULE$) {
            StandardType.LocalTimeType$ localTimeType$ = (StandardType.LocalTimeType$)standardType2;
            return new DynamicValue.Primitive((Object)LocalTime.parse(reader.readText().toString()), (StandardType)localTimeType$);
        }
        if (standardType2 == StandardType.LocalDateTimeType$.MODULE$) {
            StandardType.LocalDateTimeType$ localDateTimeType$ = (StandardType.LocalDateTimeType$)standardType2;
            return new DynamicValue.Primitive((Object)LocalDateTime.parse(reader.readText().toString()), (StandardType)localDateTimeType$);
        }
        if (standardType2 == StandardType.OffsetTimeType$.MODULE$) {
            StandardType.OffsetTimeType$ offsetTimeType$ = (StandardType.OffsetTimeType$)standardType2;
            return new DynamicValue.Primitive((Object)OffsetTime.parse(reader.readText().toString()), (StandardType)offsetTimeType$);
        }
        if (standardType2 == StandardType.OffsetDateTimeType$.MODULE$) {
            StandardType.OffsetDateTimeType$ offsetDateTimeType$ = (StandardType.OffsetDateTimeType$)standardType2;
            return new DynamicValue.Primitive((Object)OffsetDateTime.parse(reader.readText().toString()), (StandardType)offsetDateTimeType$);
        }
        if (standardType2 == StandardType.ZonedDateTimeType$.MODULE$) {
            StandardType.ZonedDateTimeType$ zonedDateTimeType$ = (StandardType.ZonedDateTimeType$)standardType2;
            return new DynamicValue.Primitive((Object)ZonedDateTime.parse(reader.readText().toString()), (StandardType)zonedDateTimeType$);
        }
        throw new DecoderError(new StringBuilder(28).append("Unsupported ZIO Schema type ").append(standardType2).toString(), DecoderError$.MODULE$.apply$default$2());
    }

    private ValueDecoder$() {
    }
}

