/*
 * Decompiled with CFR 0.152.
 */
package me.mnedokushev.zio.apache.arrow.core.codec;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.UUID;
import me.mnedokushev.zio.apache.arrow.core.codec.EncoderError;
import me.mnedokushev.zio.apache.arrow.core.codec.EncoderError$;
import me.mnedokushev.zio.apache.arrow.core.codec.ValueEncoder;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.BigIntWriter;
import org.apache.arrow.vector.complex.writer.BitWriter;
import org.apache.arrow.vector.complex.writer.DecimalWriter;
import org.apache.arrow.vector.complex.writer.FieldWriter;
import org.apache.arrow.vector.complex.writer.Float4Writer;
import org.apache.arrow.vector.complex.writer.Float8Writer;
import org.apache.arrow.vector.complex.writer.IntWriter;
import org.apache.arrow.vector.complex.writer.LargeVarBinaryWriter;
import org.apache.arrow.vector.complex.writer.SmallIntWriter;
import org.apache.arrow.vector.complex.writer.UInt1Writer;
import org.apache.arrow.vector.complex.writer.UInt2Writer;
import org.apache.arrow.vector.complex.writer.VarBinaryWriter;
import org.apache.arrow.vector.complex.writer.VarCharWriter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import zio.Chunk;
import zio.Zippable$;
import zio.schema.Schema;
import zio.schema.StandardType;

public final class ValueEncoder$ {
    public static final ValueEncoder$ MODULE$ = new ValueEncoder$();

    public <A> void encodeStruct(A value, Chunk<Schema.Field<A, ?>> fields, Chunk<ValueEncoder<?>> encoders, FieldWriter writer, BufferAllocator alloc) {
        writer.start();
        fields.zip(encoders, Zippable$.MODULE$.Zippable2()).foreach((Function1 & Serializable)x0$1 -> {
            ValueEncoder$.$anonfun$encodeStruct$1(value, writer, alloc, x0$1);
            return BoxedUnit.UNIT;
        });
        writer.end();
    }

    public <A> void encodeList(Chunk<A> chunk, ValueEncoder<A> encoder, FieldWriter writer, BufferAllocator alloc) {
        Iterator it = chunk.iterator();
        writer.startList();
        it.foreach((Function1 & Serializable)x$1 -> {
            encoder.encodeValue(x$1, (Option<String>)None$.MODULE$, writer, alloc);
            return BoxedUnit.UNIT;
        });
        writer.endList();
    }

    public <A> void encodePrimitive0(boolean nested, StandardType<A> standardType, A value, FieldWriter writer, Option<String> name, BufferAllocator alloc) {
        Tuple2 tuple2 = new Tuple2(standardType, value);
        if (tuple2 != null) {
            StandardType standardType2 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.StringType$.MODULE$.equals(standardType2) && v instanceof String) {
                String string = (String)v;
                ValueEncoder$.writeString$1(string, writer, alloc, nested, name);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType3 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.BoolType$.MODULE$.equals(standardType3) && v instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)v);
                ((BitWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer.bit(), (Function1 & Serializable)x$1 -> writer.bit(x$1), nested, name, writer)).writeBit(bl ? 1 : 0);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType4 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.ByteType$.MODULE$.equals(standardType4) && v instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)v);
                ((UInt1Writer)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer.uInt1(), (Function1 & Serializable)x$1 -> writer.uInt1(x$1), nested, name, writer)).writeUInt1(by);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType5 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.ShortType$.MODULE$.equals(standardType5) && v instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)v);
                ((SmallIntWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer.smallInt(), (Function1 & Serializable)x$1 -> writer.smallInt(x$1), nested, name, writer)).writeSmallInt(s);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType6 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.IntType$.MODULE$.equals(standardType6) && v instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)v);
                ((IntWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer.integer(), (Function1 & Serializable)x$1 -> writer.integer(x$1), nested, name, writer)).writeInt(n);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType7 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.LongType$.MODULE$.equals(standardType7) && v instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)v);
                ((BigIntWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer.bigInt(), (Function1 & Serializable)x$1 -> writer.bigInt(x$1), nested, name, writer)).writeBigInt(l);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType8 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.FloatType$.MODULE$.equals(standardType8) && v instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)v);
                ((Float4Writer)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer.float4(), (Function1 & Serializable)x$1 -> writer.float4(x$1), nested, name, writer)).writeFloat4(f);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType9 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.DoubleType$.MODULE$.equals(standardType9) && v instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)v);
                ((Float8Writer)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer.float8(), (Function1 & Serializable)x$1 -> writer.float8(x$1), nested, name, writer)).writeFloat8(d);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType10 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.BinaryType$.MODULE$.equals(standardType10) && v instanceof Chunk) {
                Chunk chunk = (Chunk)v;
                ValueEncoder$.withBuffer$1(chunk.length(), (Function1 & Serializable)buffer -> {
                    ValueEncoder$.$anonfun$encodePrimitive0$21(chunk, writer, nested, name, buffer);
                    return BoxedUnit.UNIT;
                }, alloc);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType11 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.CharType$.MODULE$.equals(standardType11) && v instanceof Character) {
                char c = BoxesRunTime.unboxToChar((Object)v);
                ((UInt2Writer)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer.uInt2(), (Function1 & Serializable)x$1 -> writer.uInt2(x$1), nested, name, writer)).writeUInt2(c);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType12 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.UUIDType$.MODULE$.equals(standardType12) && v instanceof UUID) {
                UUID uUID = (UUID)v;
                ValueEncoder$.withBuffer$1(16L, (Function1 & Serializable)buffer -> {
                    ValueEncoder$.$anonfun$encodePrimitive0$26(uUID, writer, nested, name, buffer);
                    return BoxedUnit.UNIT;
                }, alloc);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType13 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.BigDecimalType$.MODULE$.equals(standardType13) && v instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)v;
                ((DecimalWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer.decimal(), (Function1 & Serializable)x$1 -> writer.decimal(x$1), nested, name, writer)).writeDecimal(bigDecimal);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType14 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.BigIntegerType$.MODULE$.equals(standardType14) && v instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)v;
                byte[] bb = bigInteger.toByteArray();
                ValueEncoder$.withBuffer$1(bb.length, (Function1 & Serializable)buffer -> {
                    ValueEncoder$.$anonfun$encodePrimitive0$31(bb, writer, nested, name, buffer);
                    return BoxedUnit.UNIT;
                }, alloc);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType15 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.DayOfWeekType$.MODULE$.equals(standardType15) && v instanceof DayOfWeek) {
                DayOfWeek dayOfWeek = (DayOfWeek)v;
                ((IntWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer.integer(), (Function1 & Serializable)x$1 -> writer.integer(x$1), nested, name, writer)).writeInt(dayOfWeek.getValue());
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType16 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.MonthType$.MODULE$.equals(standardType16) && v instanceof Month) {
                Month month = (Month)v;
                ((IntWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer.integer(), (Function1 & Serializable)x$1 -> writer.integer(x$1), nested, name, writer)).writeInt(month.getValue());
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType17 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.MonthDayType$.MODULE$.equals(standardType17) && v instanceof MonthDay) {
                MonthDay monthDay = (MonthDay)v;
                ValueEncoder$.writeLong$1(monthDay, (Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.getDayOfMonth()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.getMonthValue()), writer, alloc, nested, name);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType18 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.PeriodType$.MODULE$.equals(standardType18) && v instanceof Period) {
                Period period = (Period)v;
                ValueEncoder$.withBuffer$1(12L, (Function1 & Serializable)buffer -> {
                    ValueEncoder$.$anonfun$encodePrimitive0$40(period, writer, nested, name, buffer);
                    return BoxedUnit.UNIT;
                }, alloc);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType19 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.YearType$.MODULE$.equals(standardType19) && v instanceof Year) {
                Year year = (Year)v;
                ((IntWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer.integer(), (Function1 & Serializable)x$1 -> writer.integer(x$1), nested, name, writer)).writeInt(year.getValue());
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType20 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.YearMonthType$.MODULE$.equals(standardType20) && v instanceof YearMonth) {
                YearMonth yearMonth = (YearMonth)v;
                ValueEncoder$.writeLong$1(yearMonth, (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.getMonthValue()), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.getYear()), writer, alloc, nested, name);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType21 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.ZoneIdType$.MODULE$.equals(standardType21) && v instanceof ZoneId) {
                ZoneId zoneId = (ZoneId)v;
                ValueEncoder$.writeString$1(zoneId.toString(), writer, alloc, nested, name);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType22 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.ZoneOffsetType$.MODULE$.equals(standardType22) && v instanceof ZoneOffset) {
                ZoneOffset zoneOffset = (ZoneOffset)v;
                ValueEncoder$.writeString$1(zoneOffset.toString(), writer, alloc, nested, name);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType23 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.DurationType$.MODULE$.equals(standardType23) && v instanceof Duration) {
                Duration duration = (Duration)v;
                ((BigIntWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer.bigInt(), (Function1 & Serializable)x$1 -> writer.bigInt(x$1), nested, name, writer)).writeBigInt(duration.toMillis());
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType24 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.InstantType$.MODULE$.equals(standardType24) && v instanceof Instant) {
                Instant instant = (Instant)v;
                ((BigIntWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer.bigInt(), (Function1 & Serializable)x$1 -> writer.bigInt(x$1), nested, name, writer)).writeBigInt(instant.toEpochMilli());
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType25 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.LocalDateType$.MODULE$.equals(standardType25) && v instanceof LocalDate) {
                LocalDate localDate = (LocalDate)v;
                ValueEncoder$.writeString$1(localDate.toString(), writer, alloc, nested, name);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType26 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.LocalTimeType$.MODULE$.equals(standardType26) && v instanceof LocalTime) {
                LocalTime localTime = (LocalTime)v;
                ValueEncoder$.writeString$1(localTime.toString(), writer, alloc, nested, name);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType27 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.LocalDateTimeType$.MODULE$.equals(standardType27) && v instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)v;
                ValueEncoder$.writeString$1(localDateTime.toString(), writer, alloc, nested, name);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType28 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.OffsetTimeType$.MODULE$.equals(standardType28) && v instanceof OffsetTime) {
                OffsetTime offsetTime = (OffsetTime)v;
                ValueEncoder$.writeString$1(offsetTime.toString(), writer, alloc, nested, name);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType29 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.OffsetDateTimeType$.MODULE$.equals(standardType29) && v instanceof OffsetDateTime) {
                OffsetDateTime offsetDateTime = (OffsetDateTime)v;
                ValueEncoder$.writeString$1(offsetDateTime.toString(), writer, alloc, nested, name);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType standardType30 = (StandardType)tuple2._1();
            Object v = tuple2._2();
            if (StandardType.ZonedDateTimeType$.MODULE$.equals(standardType30) && v instanceof ZonedDateTime) {
                ZonedDateTime zonedDateTime = (ZonedDateTime)v;
                ValueEncoder$.writeString$1(zonedDateTime.toString(), writer, alloc, nested, name);
                return;
            }
        }
        if (tuple2 != null) {
            StandardType other = (StandardType)tuple2._1();
            throw new EncoderError(new StringBuilder(36).append("Unsupported ZIO Schema StandardType ").append(other).toString(), EncoderError$.MODULE$.apply$default$2());
        }
        throw new MatchError((Object)tuple2);
    }

    public <A> void encodePrimitive(StandardType<A> standardType, A value, Option<String> name, FieldWriter writer, BufferAllocator alloc) {
        this.encodePrimitive0(true, standardType, value, writer, name, alloc);
    }

    public <A> void encodePrimitive(StandardType<A> standardType, A value, FieldWriter writer, BufferAllocator alloc) {
        this.encodePrimitive0(false, standardType, value, writer, (Option<String>)None$.MODULE$, alloc);
    }

    private static final void encodeValue0$1(ValueEncoder encoder, Object value, Function1 get, Option name, FieldWriter writer, BufferAllocator alloc) {
        encoder.encodeValue(get.apply(value), (Option<String>)name, writer, alloc);
    }

    public static final /* synthetic */ void $anonfun$encodeStruct$1(Object value$1, FieldWriter writer$1, BufferAllocator alloc$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Schema.Field field;
            Some some;
            Schema.Field field2 = (Schema.Field)tuple2._1();
            ValueEncoder encoder = (ValueEncoder)tuple2._2();
            if (field2 instanceof Schema.Field && !(some = Schema.Field$.MODULE$.unapply(field = field2)).isEmpty()) {
                String name = (String)((Tuple6)some.get())._1();
                Function1 get = (Function1)((Tuple6)some.get())._5();
                ValueEncoder$.encodeValue0$1(encoder, value$1, get, (Option)new Some((Object)name), writer$1, alloc$1);
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private static final BaseWriter resolveWriter$1(Function0 f1, Function1 f2, boolean nested$1, Option name$1, FieldWriter writer$3) {
        if (nested$1) {
            return (BaseWriter)name$1.fold(f1, f2);
        }
        return writer$3;
    }

    private static final void withBuffer$1(long size, Function1 fn, BufferAllocator alloc$3) {
        ArrowBuf buffer = alloc$3.buffer(size);
        fn.apply((Object)buffer);
        buffer.close();
    }

    public static final /* synthetic */ void $anonfun$encodePrimitive0$1(String s$1, FieldWriter writer$3, boolean nested$1, Option name$1, ArrowBuf buffer) {
        buffer.writeBytes(s$1.getBytes(StandardCharsets.UTF_8));
        ((VarCharWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer$3.varChar(), (Function1 & Serializable)x$1 -> writer$3.varChar(x$1), nested$1, name$1, writer$3)).writeVarChar(0, s$1.length(), buffer);
    }

    private static final void writeString$1(String s, FieldWriter writer$3, BufferAllocator alloc$3, boolean nested$1, Option name$1) {
        ValueEncoder$.withBuffer$1(s.length(), (Function1 & Serializable)buffer -> {
            ValueEncoder$.$anonfun$encodePrimitive0$1(s, writer$3, nested$1, name$1, buffer);
            return BoxedUnit.UNIT;
        }, alloc$3);
    }

    public static final /* synthetic */ void $anonfun$encodePrimitive0$4(Function1 fst$1, Object v$1, Function1 snd$1, FieldWriter writer$3, boolean nested$1, Option name$1, ArrowBuf buffer) {
        buffer.writeInt(BoxesRunTime.unboxToInt((Object)fst$1.apply(v$1)));
        buffer.writeInt(BoxesRunTime.unboxToInt((Object)snd$1.apply(v$1)));
        ((BigIntWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer$3.bigInt(), (Function1 & Serializable)x$1 -> writer$3.bigInt(x$1), nested$1, name$1, writer$3)).writeBigInt(buffer.getLong(0L));
    }

    private static final void writeLong$1(Object v, Function1 fst, Function1 snd, FieldWriter writer$3, BufferAllocator alloc$3, boolean nested$1, Option name$1) {
        ValueEncoder$.withBuffer$1(8L, (Function1 & Serializable)buffer -> {
            ValueEncoder$.$anonfun$encodePrimitive0$4(fst, v, snd, writer$3, nested$1, name$1, buffer);
            return BoxedUnit.UNIT;
        }, alloc$3);
    }

    public static final /* synthetic */ void $anonfun$encodePrimitive0$21(Chunk x28$1, FieldWriter writer$3, boolean nested$1, Option name$1, ArrowBuf buffer) {
        buffer.writeBytes((byte[])x28$1.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
        ((LargeVarBinaryWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer$3.largeVarBinary(), (Function1 & Serializable)x$1 -> writer$3.largeVarBinary(x$1), nested$1, name$1, writer$3)).writeLargeVarBinary(0L, (long)x28$1.length(), buffer);
    }

    public static final /* synthetic */ void $anonfun$encodePrimitive0$26(UUID x34$1, FieldWriter writer$3, boolean nested$1, Option name$1, ArrowBuf buffer) {
        buffer.writeLong(x34$1.getMostSignificantBits());
        buffer.writeLong(x34$1.getLeastSignificantBits());
        ((VarBinaryWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer$3.varBinary(), (Function1 & Serializable)x$1 -> writer$3.varBinary(x$1), nested$1, name$1, writer$3)).writeVarBinary(0, 16, buffer);
    }

    public static final /* synthetic */ void $anonfun$encodePrimitive0$31(byte[] bb$1, FieldWriter writer$3, boolean nested$1, Option name$1, ArrowBuf buffer) {
        buffer.writeBytes(bb$1);
        ((VarBinaryWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer$3.varBinary(), (Function1 & Serializable)x$1 -> writer$3.varBinary(x$1), nested$1, name$1, writer$3)).writeVarBinary(0, bb$1.length, buffer);
    }

    public static final /* synthetic */ void $anonfun$encodePrimitive0$40(Period x52$1, FieldWriter writer$3, boolean nested$1, Option name$1, ArrowBuf buffer) {
        buffer.writeInt(x52$1.getDays());
        buffer.writeInt(x52$1.getMonths());
        buffer.writeInt(x52$1.getYears());
        ((VarBinaryWriter)ValueEncoder$.resolveWriter$1((Function0 & Serializable)() -> writer$3.varBinary(), (Function1 & Serializable)x$1 -> writer$3.varBinary(x$1), nested$1, name$1, writer$3)).writeVarBinary(0, 12, buffer);
    }

    private ValueEncoder$() {
    }
}

