/*
 * Decompiled with CFR 0.152.
 */
package me.mnedokushev.zio.apache.arrow.core.codec;

import java.io.Serializable;
import me.mnedokushev.zio.apache.arrow.core.codec.DecoderError;
import me.mnedokushev.zio.apache.arrow.core.codec.DecoderError$;
import me.mnedokushev.zio.apache.arrow.core.codec.ValueVectorDecoder;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.impl.NullableStructReaderImpl;
import org.apache.arrow.vector.complex.impl.UnionListReader;
import org.apache.arrow.vector.complex.reader.FieldReader;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple6;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Chunk;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.ZIO;
import zio.schema.DynamicValue;
import zio.schema.Schema;
import zio.schema.StandardType;
import zio.schema.TypeId;

public final class ValueVectorDecoder$ {
    public static final ValueVectorDecoder$ MODULE$ = new ValueVectorDecoder$();

    public <V extends ValueVector, A> ValueVectorDecoder<V, A> apply(ValueVectorDecoder<V, A> decoder) {
        return decoder;
    }

    public <V extends ValueVector, A> ValueVectorDecoder<V, A> primitive(Schema<A> schema) {
        return new ValueVectorDecoder<V, A>(schema){
            private final Schema schema$1;

            public final ZIO<Object, Throwable, Chunk<A>> decodeZIO(V vec) {
                return ValueVectorDecoder.decodeZIO$(this, vec);
            }

            public final Either<Throwable, Chunk<A>> decode(V vec) {
                return ValueVectorDecoder.decode$(this, vec);
            }

            public final <B> ValueVectorDecoder<V, B> map(Function1<A, B> f) {
                return ValueVectorDecoder.map$(this, f);
            }

            public Chunk<A> decodeUnsafe(V vec) {
                Schema schema = this.schema$1;
                if (schema instanceof Schema.Primitive) {
                    Schema.Primitive primitive = (Schema.Primitive)schema;
                    StandardType standardType = primitive.standardType();
                    int len = vec.getValueCount();
                    ChunkBuilder builder = ChunkBuilder$.MODULE$.make(len);
                    FieldReader reader = vec.getReader();
                    for (int idx = 0; idx < len; ++idx) {
                        reader.setPosition(idx);
                        DynamicValue dynamicValue = ValueVectorDecoder$.MODULE$.decodePrimitive(standardType, reader);
                        Either either = dynamicValue.toTypedValue(this.schema$1);
                        if (either instanceof Right) {
                            Right right = (Right)either;
                            Object v = right.value();
                            builder.addOne(v);
                            continue;
                        }
                        if (either instanceof Left) {
                            Left left = (Left)either;
                            String message = (String)left.value();
                            throw new DecoderError(message, DecoderError$.MODULE$.apply$default$2());
                        }
                        throw new MatchError((Object)either);
                    }
                    return (Chunk)builder.result();
                }
                throw new DecoderError("Given ZIO schema must be of type Schema.Primitive[Val]", DecoderError$.MODULE$.apply$default$2());
            }
            {
                this.schema$1 = schema$1;
                ValueVectorDecoder.$init$(this);
            }
        };
    }

    public <A> ValueVectorDecoder<ListVector, Chunk<A>> list(Schema<A> schema) {
        return new ValueVectorDecoder<ListVector, Chunk<A>>(schema){
            private final Schema schema$2;

            public final ZIO decodeZIO(ValueVector vec) {
                return ValueVectorDecoder.decodeZIO$(this, vec);
            }

            public final Either decode(ValueVector vec) {
                return ValueVectorDecoder.decode$(this, vec);
            }

            public final <B> ValueVectorDecoder<ListVector, B> map(Function1<Chunk<A>, B> f) {
                return ValueVectorDecoder.map$(this, f);
            }

            public Chunk<Chunk<A>> decodeUnsafe(ListVector vec) {
                int len = vec.getValueCount();
                ChunkBuilder builder = ChunkBuilder$.MODULE$.make(len);
                UnionListReader reader = vec.getReader();
                for (int idx = 0; idx < len; ++idx) {
                    ChunkBuilder innerBuilder = ChunkBuilder$.MODULE$.make();
                    reader.setPosition(idx);
                    while (reader.next()) {
                        BoxedUnit boxedUnit;
                        if (reader.isSet()) {
                            DynamicValue dynamicValue = ValueVectorDecoder$.MODULE$.decodeSchema((Option<String>)None$.MODULE$, this.schema$2, (FieldReader)reader);
                            Either either = dynamicValue.toTypedValue(this.schema$2);
                            if (either instanceof Right) {
                                Right right = (Right)either;
                                Object v = right.value();
                                boxedUnit = (ChunkBuilder)innerBuilder.addOne(v);
                                continue;
                            }
                            if (either instanceof Left) {
                                Left left = (Left)either;
                                String message = (String)left.value();
                                throw new DecoderError(message, DecoderError$.MODULE$.apply$default$2());
                            }
                            throw new MatchError((Object)either);
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    builder.addOne(innerBuilder.result());
                }
                return (Chunk)builder.result();
            }
            {
                this.schema$2 = schema$2;
                ValueVectorDecoder.$init$(this);
            }
        };
    }

    public <A> ValueVectorDecoder<StructVector, A> struct(Schema<A> schema) {
        return new ValueVectorDecoder<StructVector, A>(schema){
            private final Schema schema$3;

            public final ZIO decodeZIO(ValueVector vec) {
                return ValueVectorDecoder.decodeZIO$(this, vec);
            }

            public final Either decode(ValueVector vec) {
                return ValueVectorDecoder.decode$(this, vec);
            }

            public final <B> ValueVectorDecoder<StructVector, B> map(Function1<A, B> f) {
                return ValueVectorDecoder.map$(this, f);
            }

            public Chunk<A> decodeUnsafe(StructVector vec) {
                Schema schema = this.schema$3;
                if (schema instanceof Schema.Record) {
                    Schema.Record record = (Schema.Record)schema;
                    int len = vec.getValueCount();
                    ChunkBuilder builder = ChunkBuilder$.MODULE$.make(len);
                    NullableStructReaderImpl reader = vec.getReader();
                    for (int idx = 0; idx < len; ++idx) {
                        reader.setPosition(idx);
                        DynamicValue dynamicValue = ValueVectorDecoder$.MODULE$.decodeCaseClass(record.fields(), (FieldReader)reader);
                        Either either = dynamicValue.toTypedValue(this.schema$3);
                        if (either instanceof Right) {
                            Right right = (Right)either;
                            Object v = right.value();
                            builder.addOne(v);
                            continue;
                        }
                        if (either instanceof Left) {
                            Left left = (Left)either;
                            String message = (String)left.value();
                            throw new DecoderError(message, DecoderError$.MODULE$.apply$default$2());
                        }
                        throw new MatchError((Object)either);
                    }
                    return (Chunk)builder.result();
                }
                throw new DecoderError("Given ZIO schema must be of type Schema.Record[Val]", DecoderError$.MODULE$.apply$default$2());
            }
            {
                this.schema$3 = schema$3;
                ValueVectorDecoder.$init$(this);
            }
        };
    }

    public <A> DynamicValue decodeSchema(Option<String> name, Schema<A> schema0, FieldReader reader0) {
        Schema schema;
        while (true) {
            FieldReader reader = (FieldReader)name.fold((Function0 & Serializable)() -> reader0.reader(), (Function1 & Serializable)x$1 -> reader0.reader(x$1));
            schema = schema0;
            if (schema instanceof Schema.Primitive) {
                Schema.Primitive primitive = (Schema.Primitive)schema;
                StandardType standardType = primitive.standardType();
                return this.decodePrimitive(standardType, reader);
            }
            if (schema instanceof Schema.Record) {
                Schema.Record record = (Schema.Record)schema;
                return this.decodeCaseClass(record.fields(), reader);
            }
            if (schema instanceof Schema.Sequence) {
                Schema.Sequence sequence = (Schema.Sequence)schema;
                Schema elemSchema = sequence.elementSchema();
                return this.decodeSequence(elemSchema, reader);
            }
            if (!(schema instanceof Schema.Lazy)) break;
            Schema.Lazy lazy = (Schema.Lazy)schema;
            schema0 = lazy.schema();
        }
        throw new DecoderError(new StringBuilder(28).append("Unsupported ZIO Schema type ").append(schema).toString(), DecoderError$.MODULE$.apply$default$2());
    }

    public <A> DynamicValue decodeCaseClass(Chunk<Schema.Field<A, ?>> fields, FieldReader reader0) {
        ListMap values = (ListMap)ListMap$.MODULE$.apply((Seq)fields.map((Function1 & Serializable)x0$1 -> {
            Some some;
            Schema.Field field = x0$1;
            if (field != null && !(some = Schema.Field$.MODULE$.unapply(field)).isEmpty()) {
                String name = (String)((Tuple6)some.get())._1();
                Schema schema0 = (Schema)((Tuple6)some.get())._2();
                DynamicValue value = MODULE$.decodeSchema((Option<String>)new Some((Object)name), schema0, reader0);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)value);
            }
            throw new MatchError((Object)field);
        }));
        return new DynamicValue.Record((TypeId)TypeId.Structural$.MODULE$, values);
    }

    public <A> DynamicValue decodeSequence(Schema<A> schema0, FieldReader reader0) {
        ChunkBuilder builder = ChunkBuilder$.MODULE$.make();
        while (reader0.next()) {
            Object object = reader0.isSet() ? builder.addOne((Object)this.decodeSchema((Option<String>)None$.MODULE$, schema0, reader0)) : BoxedUnit.UNIT;
        }
        return new DynamicValue.Sequence((Chunk)builder.result());
    }

    public <A> DynamicValue decodePrimitive(StandardType<A> standardType, FieldReader reader0) {
        StandardType<A> standardType2 = standardType;
        if (standardType2 == StandardType.BoolType$.MODULE$) {
            StandardType.BoolType$ boolType$ = (StandardType.BoolType$)standardType2;
            return new DynamicValue.Primitive((Object)BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(reader0.readBoolean())), (StandardType)boolType$);
        }
        if (standardType2 == StandardType.IntType$.MODULE$) {
            StandardType.IntType$ intType$ = (StandardType.IntType$)standardType2;
            return new DynamicValue.Primitive((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(reader0.readInteger())), (StandardType)intType$);
        }
        if (standardType2 == StandardType.LongType$.MODULE$) {
            StandardType.LongType$ longType$ = (StandardType.LongType$)standardType2;
            return new DynamicValue.Primitive((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(reader0.readLong())), (StandardType)longType$);
        }
        if (standardType2 == StandardType.FloatType$.MODULE$) {
            StandardType.FloatType$ floatType$ = (StandardType.FloatType$)standardType2;
            return new DynamicValue.Primitive((Object)BoxesRunTime.boxToFloat((float)Predef$.MODULE$.Float2float(reader0.readFloat())), (StandardType)floatType$);
        }
        if (standardType2 == StandardType.DoubleType$.MODULE$) {
            StandardType.DoubleType$ doubleType$ = (StandardType.DoubleType$)standardType2;
            return new DynamicValue.Primitive((Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(reader0.readDouble())), (StandardType)doubleType$);
        }
        if (standardType2 == StandardType.StringType$.MODULE$) {
            StandardType.StringType$ stringType$ = (StandardType.StringType$)standardType2;
            return new DynamicValue.Primitive((Object)reader0.readText().toString(), (StandardType)stringType$);
        }
        throw new DecoderError(new StringBuilder(28).append("Unsupported ZIO Schema type ").append(standardType2).toString(), DecoderError$.MODULE$.apply$default$2());
    }

    private ValueVectorDecoder$() {
    }
}

