/*
 * Decompiled with CFR 0.152.
 */
package me.mnedokushev.zio.apache.arrow.core.codec;

import java.io.Serializable;
import me.mnedokushev.zio.apache.arrow.core.codec.EncoderError;
import me.mnedokushev.zio.apache.arrow.core.codec.EncoderError$;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple6;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.control.NonFatal$;
import zio.Chunk;
import zio.schema.Schema;
import zio.schema.StandardType;

public final class SchemaEncoder$ {
    public static final SchemaEncoder$ MODULE$ = new SchemaEncoder$();

    public <A> Either<Throwable, Schema> schemaRoot(zio.schema.Schema<A> schema) {
        Left left;
        try {
            zio.schema.Schema<A> schema2 = schema;
            if (!(schema2 instanceof Schema.Record)) {
                throw new EncoderError("Given ZIO schema mut be of type Schema.Record[Val]", EncoderError$.MODULE$.apply$default$2());
            }
            Schema.Record record = (Schema.Record)schema2;
            Chunk fields = record.fields().map((Function1 & Serializable)x0$1 -> {
                Some some;
                Schema.Field field = x0$1;
                if (field != null && !(some = Schema.Field$.MODULE$.unapply(field)).isEmpty()) {
                    String name = (String)((Tuple6)some.get())._1();
                    zio.schema.Schema schemaField = (zio.schema.Schema)((Tuple6)some.get())._2();
                    return this.encodeSchema$1(name, schemaField, false);
                }
                throw new MatchError((Object)field);
            });
            left = package$.MODULE$.Right().apply((Object)new Schema((Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)fields.toList()).asJava()));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof EncoderError) {
                EncoderError encoderError = (EncoderError)throwable2;
                left = package$.MODULE$.Left().apply((Object)encoderError);
            }
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable ex = (Throwable)option.get();
                left = package$.MODULE$.Left().apply((Object)new EncoderError("Error encoding schema", (Option<Throwable>)new Some((Object)ex)));
            }
            throw throwable;
        }
        return left;
    }

    private <A> Field encodePrimitive(String name, StandardType<A> standardType, boolean nullable) {
        StandardType<A> standardType2 = standardType;
        if (StandardType.IntType$.MODULE$.equals(standardType2)) {
            return this.field0$1((ArrowType)new ArrowType.Int(32, true), name, nullable);
        }
        if (StandardType.LongType$.MODULE$.equals(standardType2)) {
            return this.field0$1((ArrowType)new ArrowType.Int(64, true), name, nullable);
        }
        if (StandardType.FloatType$.MODULE$.equals(standardType2)) {
            return this.field0$1((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.HALF), name, nullable);
        }
        if (StandardType.DoubleType$.MODULE$.equals(standardType2)) {
            return this.field0$1((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), name, nullable);
        }
        if (StandardType.StringType$.MODULE$.equals(standardType2)) {
            return this.field0$1((ArrowType)new ArrowType.Utf8(), name, nullable);
        }
        throw new EncoderError(new StringBuilder(36).append("Unsupported ZIO Schema StandardType ").append(standardType2).toString(), EncoderError$.MODULE$.apply$default$2());
    }

    public Field field(String name, ArrowType arrowType, boolean nullable) {
        return new Field(name, new FieldType(nullable, arrowType, null), null);
    }

    public Field fieldNullable(String name, ArrowType arrowType) {
        return this.field(name, arrowType, true);
    }

    public Field fieldNotNullable(String name, ArrowType arrowType) {
        return this.field(name, arrowType, false);
    }

    private final Field encodeSchema$1(String name, zio.schema.Schema schemaField, boolean nullable) {
        zio.schema.Schema schema;
        while (true) {
            if ((schema = schemaField) instanceof Schema.Primitive) {
                Schema.Primitive primitive = (Schema.Primitive)schema;
                StandardType standardType = primitive.standardType();
                return this.encodePrimitive(name, standardType, nullable);
            }
            if (schema instanceof Schema.Optional) {
                Schema.Optional optional = (Schema.Optional)schema;
                zio.schema.Schema schemaOpt = optional.schema();
                nullable = true;
                schemaField = schemaOpt;
                continue;
            }
            if (schema instanceof Schema.Record) {
                return this.field(name, (ArrowType)new ArrowType.Struct(), nullable);
            }
            if (schema instanceof Schema.Sequence) {
                return this.field(name, (ArrowType)new ArrowType.List(), nullable);
            }
            if (!(schema instanceof Schema.Lazy)) break;
            Schema.Lazy lazy = (Schema.Lazy)schema;
            schemaField = lazy.schema();
        }
        throw new EncoderError(new StringBuilder(28).append("Unsupported ZIO Schema type ").append(schema).toString(), EncoderError$.MODULE$.apply$default$2());
    }

    private final Field field0$1(ArrowType arrowType, String name$1, boolean nullable$1) {
        return this.field(name$1, arrowType, nullable$1);
    }

    private SchemaEncoder$() {
    }
}

