/*
 * Decompiled with CFR 0.152.
 */
package me.minidigger.minimessage;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringJoiner;
import javax.annotation.Nonnull;

public class MiniMarkdownParser {
    private MiniMarkdownParser() {
    }

    @Nonnull
    public static String stripMarkdown(@Nonnull String input) {
        return MiniMarkdownParser.handle(input, true);
    }

    @Nonnull
    public static String parse(@Nonnull String input) {
        return MiniMarkdownParser.handle(input, false);
    }

    @Nonnull
    private static String handle(@Nonnull String input, boolean strip) {
        StringBuilder sb = new StringBuilder();
        int bold = -1;
        Insert boldSkip = null;
        int italic = -1;
        Insert italicSkip = null;
        int underline = -1;
        Insert underlineSkip = null;
        ArrayList<Insert> inserts = new ArrayList<Insert>();
        int skip = 0;
        int i = 0;
        while (i + skip < input.length()) {
            char n;
            int currIndex = i + skip;
            char c = input.charAt(currIndex);
            boolean shouldSkip = false;
            if (c == '*') {
                n = MiniMarkdownParser.next(currIndex, input);
                if (n == '*') {
                    if (bold == -1) {
                        bold = sb.length();
                        boldSkip = new Insert(sb.length(), c + "");
                    } else {
                        inserts.add(new Insert(bold, "<bold>"));
                        inserts.add(new Insert(sb.length(), "</bold>"));
                        bold = -1;
                    }
                    ++skip;
                } else if (italic == -1) {
                    italic = sb.length();
                    italicSkip = new Insert(sb.length(), c + "");
                } else {
                    inserts.add(new Insert(italic, "<italic>"));
                    inserts.add(new Insert(sb.length(), "</italic>"));
                    italic = -1;
                }
                shouldSkip = true;
            } else if (c == '_') {
                n = MiniMarkdownParser.next(currIndex, input);
                if (n == '_') {
                    if (bold == -1) {
                        bold = sb.length();
                        boldSkip = new Insert(sb.length(), c + "");
                    } else {
                        inserts.add(new Insert(bold, "<bold>"));
                        inserts.add(new Insert(sb.length(), "</bold>"));
                        bold = -1;
                    }
                    ++skip;
                } else if (italic == -1) {
                    italic = currIndex;
                    italicSkip = new Insert(sb.length(), c + "");
                } else {
                    inserts.add(new Insert(italic, "<italic>"));
                    inserts.add(new Insert(currIndex - 1, "</italic>"));
                    italic = -1;
                }
                shouldSkip = true;
            } else if (c == '~' && (n = MiniMarkdownParser.next(currIndex, input)) == '~') {
                if (underline == -1) {
                    underline = sb.length();
                    underlineSkip = new Insert(sb.length(), c + "");
                } else {
                    inserts.add(new Insert(underline, "<underline>"));
                    inserts.add(new Insert(sb.length(), "</underline>"));
                    underline = -1;
                }
                ++skip;
                shouldSkip = true;
            }
            if (!shouldSkip) {
                sb.append(c);
            }
            ++i;
        }
        if (strip) {
            inserts.clear();
        } else {
            inserts.sort(Comparator.comparing(Insert::getPos).thenComparing(Insert::getValue).reversed());
        }
        if (underline != -1) {
            inserts.add(underlineSkip);
        }
        if (bold != -1) {
            inserts.add(boldSkip);
        }
        if (italic != -1) {
            inserts.add(italicSkip);
        }
        for (Insert el : inserts) {
            sb.insert(el.getPos(), el.getValue());
        }
        return sb.toString();
    }

    private static char next(int index, @Nonnull String input) {
        if (index < input.length() - 1) {
            return input.charAt(index + 1);
        }
        return ' ';
    }

    static class Insert {
        private final int pos;
        private final String value;

        public int getPos() {
            return this.pos;
        }

        @Nonnull
        public String getValue() {
            return this.value;
        }

        public Insert(int pos, @Nonnull String value) {
            this.pos = pos;
            this.value = value;
        }

        @Nonnull
        public String toString() {
            return new StringJoiner(", ", Insert.class.getSimpleName() + "[", "]").add("pos=" + this.pos).add("value='" + this.value + "'").toString();
        }
    }
}

