/*
 * Decompiled with CFR 0.152.
 */
package org.craft.atom.protocol.textline;

import java.nio.charset.Charset;
import org.craft.atom.protocol.AbstractProtocolEncoder;
import org.craft.atom.protocol.ProtocolEncoder;
import org.craft.atom.protocol.ProtocolException;

public class TextLineEncoder
extends AbstractProtocolEncoder
implements ProtocolEncoder<String> {
    private String delimiter = "\n";
    private int maxLineLength = Integer.MAX_VALUE;

    public TextLineEncoder() {
    }

    public TextLineEncoder(Charset charset) {
        this.charset = charset;
    }

    public TextLineEncoder(Charset charset, String delimiter) {
        this(charset);
        this.delimiter = delimiter;
    }

    public TextLineEncoder(Charset charset, String delimiter, int maxLineLength) {
        this(charset, delimiter);
        this.maxLineLength = maxLineLength;
    }

    public byte[] encode(String str) throws ProtocolException {
        byte[] lineBytes = (str = str + this.delimiter).getBytes(this.charset);
        if (lineBytes.length > this.maxLineLength) {
            throw new ProtocolException("Line is too long, maxLineLength=" + this.maxLineLength);
        }
        return lineBytes;
    }

    public String toString() {
        return "TextLineEncoder(super=" + super.toString() + ", delimiter=" + this.getDelimiter() + ")";
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

