/*
 * Decompiled with CFR 0.152.
 */
package org.craft.atom.protocol.textline;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.craft.atom.protocol.AbstractProtocolDecoder;
import org.craft.atom.protocol.ProtocolDecoder;
import org.craft.atom.protocol.ProtocolException;
import org.craft.atom.protocol.ProtocolExceptionType;

public class TextLineDecoder
extends AbstractProtocolDecoder
implements ProtocolDecoder<String> {
    private String delimiter = "\n";
    private byte[] delimiterBytes = this.delimiter.getBytes(this.charset);
    private int delimiterLen = this.delimiterBytes.length;

    public TextLineDecoder() {
    }

    public TextLineDecoder(Charset charset) {
        this.charset = charset;
    }

    public TextLineDecoder(Charset charset, String delimiter) {
        this(charset);
        this.delimiter = delimiter;
        this.delimiterBytes = delimiter.getBytes(this.charset);
        this.delimiterLen = this.delimiterBytes.length;
    }

    public TextLineDecoder(Charset charset, String delimiter, int defaultBufferSize) {
        this(charset, delimiter);
        this.defaultBufferSize = defaultBufferSize;
        this.buf.reset(defaultBufferSize);
    }

    public TextLineDecoder(Charset charset, String delimiter, int defaultBufferSize, int maxLineLength) {
        this(charset, delimiter, defaultBufferSize);
        this.maxSize = maxLineLength;
    }

    public List<String> decode(byte[] bytes) throws ProtocolException {
        ArrayList<String> strs = new ArrayList<String>();
        this.reset();
        this.buf.append(bytes);
        while (this.searchIndex < this.buf.length()) {
            int idx = this.buf.indexOf(this.delimiterBytes, this.searchIndex);
            if (idx < 0) {
                if (this.buf.length() > this.maxSize) {
                    this.buf.reset(this.defaultBufferSize);
                    throw new ProtocolException(ProtocolExceptionType.LINE_LENGTH_LIMIT, new Object[]{this.maxSize});
                }
                this.searchIndex = this.buf.length();
                break;
            }
            byte[] lineBytes = this.buf.array(this.splitIndex, idx);
            if (lineBytes.length > this.maxSize) {
                this.buf.reset(this.defaultBufferSize);
                throw new ProtocolException(ProtocolExceptionType.LINE_LENGTH_LIMIT, new Object[]{this.maxSize});
            }
            this.searchIndex = this.splitIndex = idx + this.delimiterLen;
            strs.add(new String(lineBytes, this.charset));
        }
        return strs;
    }

    public String toString() {
        return "TextLineDecoder(super=" + super.toString() + ", delimiter=" + this.getDelimiter() + ")";
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

