/*
 * Decompiled with CFR 0.152.
 */
package org.craft.atom.protocol.ssl;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.ws.ProtocolException;
import org.craft.atom.protocol.ssl.SslHandshakeHandler;
import org.craft.atom.util.buffer.AdaptiveByteBuffer;

public class SslCodec {
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private boolean clientMode;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;
    private AdaptiveByteBuffer inNetBuffer;
    private AdaptiveByteBuffer outNetBuffer;
    private AdaptiveByteBuffer appBuffer;
    private final AdaptiveByteBuffer emptyBuffer = AdaptiveByteBuffer.allocate((int)0);
    private boolean handshakeComplete;
    private SslHandshakeHandler handshakeHandler;
    private InetSocketAddress peer;
    private SSLContext sslContext;
    private SSLEngine sslEngine;
    private SSLEngineResult.HandshakeStatus handshakeStatus;

    public SslCodec(SSLContext sslContext, SslHandshakeHandler sslHandler) {
        this.sslContext = sslContext;
        this.handshakeHandler = sslHandler;
    }

    public void init() {
        this.sslEngine = this.peer == null ? this.sslContext.createSSLEngine() : this.sslContext.createSSLEngine(this.peer.getHostName(), this.peer.getPort());
        this.sslEngine.setUseClientMode(this.clientMode);
        if (!this.clientMode) {
            this.sslEngine.setWantClientAuth(this.wantClientAuth);
            this.sslEngine.setNeedClientAuth(this.needClientAuth);
        }
        if (this.enabledCipherSuites != null) {
            this.sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            this.sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        try {
            this.sslEngine.beginHandshake();
        }
        catch (SSLException e) {
            throw new ProtocolException((Throwable)e);
        }
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        this.handshakeComplete = false;
    }

    public synchronized byte[] decode(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            byte[] out = null;
            int len = data.length;
            if (this.inNetBuffer == null) {
                this.inNetBuffer = AdaptiveByteBuffer.allocate((int)len).setAutoExpand(true);
            }
            this.inNetBuffer.put(data);
            if (!this.handshakeComplete) {
                this.handshake0();
            } else {
                this.inNetBuffer.flip();
                if (!this.inNetBuffer.hasRemaining()) {
                    return null;
                }
                SSLEngineResult res = this.unwrap();
                if (this.inNetBuffer.hasRemaining()) {
                    this.inNetBuffer.compact();
                } else {
                    this.inNetBuffer = null;
                }
                this.checkStatus(res);
                this.renegotiateIfNeeded(res);
                out = this.getBytes(this.fetchAppBuffer());
            }
            if (this.isInboundDone()) {
                this.inNetBuffer = null;
            }
            return out;
        }
        catch (Exception e) {
            throw new ProtocolException((Throwable)e);
        }
    }

    private void handshake0() throws SSLException {
        block6: while (true) {
            switch (this.handshakeStatus) {
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    this.handshakeComplete = true;
                    return;
                }
                case NEED_TASK: {
                    this.handshakeStatus = this.doTasks();
                    continue block6;
                }
                case NEED_UNWRAP: {
                    SSLEngineResult.Status status = this.unwrapHandshake();
                    if ((status != SSLEngineResult.Status.BUFFER_UNDERFLOW || this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) && !this.isInboundDone()) continue block6;
                    return;
                }
                case NEED_WRAP: {
                    SSLEngineResult result;
                    if (this.outNetBuffer != null && this.outNetBuffer.hasRemaining()) {
                        return;
                    }
                    this.createOutNetBuffer(0);
                    while ((result = this.sslEngine.wrap(this.emptyBuffer.buf(), this.outNetBuffer.buf())).getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        this.outNetBuffer.capacity(this.outNetBuffer.capacity() << 1);
                        this.outNetBuffer.limit(this.outNetBuffer.capacity());
                    }
                    this.outNetBuffer.flip();
                    this.handshakeStatus = result.getHandshakeStatus();
                    this.writeNetBuffer();
                    continue block6;
                }
            }
            break;
        }
        String msg = "Invalid handshaking state" + (Object)((Object)this.handshakeStatus) + " while processing the Handshake for session.";
        throw new IllegalStateException(msg);
    }

    private void writeNetBuffer() throws SSLException {
        if (this.outNetBuffer == null || !this.outNetBuffer.hasRemaining()) {
            return;
        }
        AdaptiveByteBuffer writeBuffer = this.fetchOutNetBuffer();
        this.handshakeHandler.needWrite(this.getBytes(writeBuffer));
        while (this.needToCompleteHandshake()) {
            try {
                this.handshake0();
            }
            catch (SSLException ssle) {
                SSLHandshakeException newSsle = new SSLHandshakeException("SSL handshake failed.");
                newSsle.initCause(ssle);
                throw newSsle;
            }
            AdaptiveByteBuffer outNetBuffer = this.fetchOutNetBuffer();
            if (outNetBuffer == null || !outNetBuffer.hasRemaining()) continue;
            this.handshakeHandler.needWrite(this.getBytes(writeBuffer));
        }
    }

    private void createOutNetBuffer(int expectedRemaining) {
        int capacity = Math.max(expectedRemaining, this.sslEngine.getSession().getPacketBufferSize());
        if (this.outNetBuffer != null) {
            this.outNetBuffer.capacity(capacity);
        } else {
            this.outNetBuffer = AdaptiveByteBuffer.allocate((int)capacity).minimumCapacity(0);
        }
    }

    private byte[] getBytes(AdaptiveByteBuffer buf) {
        int len = buf.remaining();
        if (len == 0) {
            return null;
        }
        byte[] bytes = new byte[len];
        buf.get(bytes);
        return bytes;
    }

    private AdaptiveByteBuffer fetchOutNetBuffer() {
        AdaptiveByteBuffer answer = this.outNetBuffer;
        if (answer == null) {
            return this.emptyBuffer;
        }
        this.outNetBuffer = null;
        return answer.shrink();
    }

    private AdaptiveByteBuffer fetchAppBuffer() {
        AdaptiveByteBuffer appBuffer = this.appBuffer.flip();
        this.appBuffer = null;
        return appBuffer;
    }

    private boolean isInboundDone() {
        return this.sslEngine == null || this.sslEngine.isInboundDone();
    }

    private boolean needToCompleteHandshake() {
        return this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && !this.isInboundDone();
    }

    private SSLEngineResult.Status unwrapHandshake() throws SSLException {
        if (this.inNetBuffer != null) {
            this.inNetBuffer.flip();
        }
        if (this.inNetBuffer == null || !this.inNetBuffer.hasRemaining()) {
            return SSLEngineResult.Status.BUFFER_UNDERFLOW;
        }
        SSLEngineResult res = this.unwrap();
        this.handshakeStatus = res.getHandshakeStatus();
        this.checkStatus(res);
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED && res.getStatus() == SSLEngineResult.Status.OK && this.inNetBuffer.hasRemaining()) {
            res = this.unwrap();
            if (this.inNetBuffer.hasRemaining()) {
                this.inNetBuffer.compact();
            } else {
                this.inNetBuffer = null;
            }
            this.renegotiateIfNeeded(res);
        } else if (this.inNetBuffer.hasRemaining()) {
            this.inNetBuffer.compact();
        } else {
            this.inNetBuffer = null;
        }
        return res.getStatus();
    }

    private void renegotiateIfNeeded(SSLEngineResult res) throws SSLException {
        if (res.getStatus() != SSLEngineResult.Status.CLOSED && res.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && res.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.handshakeComplete = false;
            this.handshakeStatus = res.getHandshakeStatus();
            this.handshake0();
        }
    }

    private SSLEngineResult unwrap() throws SSLException {
        SSLEngineResult res;
        if (this.appBuffer == null) {
            this.appBuffer = AdaptiveByteBuffer.allocate((int)this.inNetBuffer.remaining());
        } else {
            this.appBuffer.expand(this.inNetBuffer.remaining());
        }
        SSLEngineResult.Status status = null;
        SSLEngineResult.HandshakeStatus handshakeStatus = null;
        do {
            res = this.sslEngine.unwrap(this.inNetBuffer.buf(), this.appBuffer.buf());
            status = res.getStatus();
            handshakeStatus = res.getHandshakeStatus();
            if (status != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
            this.appBuffer.capacity(this.appBuffer.capacity() << 1);
            this.appBuffer.limit(this.appBuffer.capacity());
        } while ((status == SSLEngineResult.Status.OK || status == SSLEngineResult.Status.BUFFER_OVERFLOW) && (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP));
        return res;
    }

    private void checkStatus(SSLEngineResult res) throws SSLException {
        SSLEngineResult.Status status = res.getStatus();
        if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
            throw new SSLException("SSLEngine error during decrypt: " + (Object)((Object)status) + " inNetBuffer: " + this.inNetBuffer + "appBuffer: " + this.appBuffer);
        }
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    public void handshake() {
        try {
            this.handshake0();
        }
        catch (Exception e) {
            throw new ProtocolException((Throwable)e);
        }
    }

    public synchronized byte[] encode(byte[] data) {
        if (data == null) {
            return null;
        }
        if (!this.handshakeComplete) {
            throw new IllegalStateException();
        }
        ByteBuffer src = ByteBuffer.wrap(data);
        this.createOutNetBuffer(src.remaining());
        try {
            while (src.hasRemaining()) {
                SSLEngineResult result = this.sslEngine.wrap(src, this.outNetBuffer.buf());
                if (result.getStatus() == SSLEngineResult.Status.OK) {
                    if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                    this.doTasks();
                    continue;
                }
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    this.outNetBuffer.capacity(this.outNetBuffer.capacity() << 1);
                    this.outNetBuffer.limit(this.outNetBuffer.capacity());
                    continue;
                }
                throw new SSLException("SSLEngine error during encrypt: " + (Object)((Object)result.getStatus()) + " src: " + src + "outNetBuffer: " + this.outNetBuffer);
            }
            this.outNetBuffer.flip();
            return this.getBytes(this.fetchOutNetBuffer());
        }
        catch (Exception e) {
            throw new ProtocolException((Throwable)e);
        }
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public InetSocketAddress getPeer() {
        return this.peer;
    }

    public void setPeer(InetSocketAddress peer) {
        this.peer = peer;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public void setSslEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.handshakeStatus;
    }
}

