/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mf.base;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.mattstudios.mf.annotations.Alias;
import me.mattstudios.mf.annotations.Completion;
import me.mattstudios.mf.annotations.Default;
import me.mattstudios.mf.annotations.MaxArgs;
import me.mattstudios.mf.annotations.MinArgs;
import me.mattstudios.mf.annotations.Permission;
import me.mattstudios.mf.annotations.SubCommand;
import me.mattstudios.mf.base.CommandBase;
import me.mattstudios.mf.base.CompletionHandler;
import me.mattstudios.mf.base.MessageHandler;
import me.mattstudios.mf.base.ParameterHandler;
import me.mattstudios.mf.base.components.CommandData;
import me.mattstudios.mf.exceptions.InvalidCompletionIdException;
import me.mattstudios.mf.exceptions.InvalidParamAnnotationException;
import me.mattstudios.mf.exceptions.InvalidParamException;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHandler
extends Command {
    private Map<String, CommandData> subCommands;
    private ParameterHandler parameterHandler;
    private CompletionHandler completionHandler;
    private MessageHandler messageHandler;

    CommandHandler(ParameterHandler parameterHandler, CompletionHandler completionHandler, MessageHandler messageHandler, CommandBase command, String commandName, List<String> aliases) {
        super(commandName);
        this.parameterHandler = parameterHandler;
        this.completionHandler = completionHandler;
        this.messageHandler = messageHandler;
        this.setAliases(aliases);
        this.subCommands = new HashMap<String, CommandData>();
        this.addSubCommands(command, commandName);
    }

    void addSubCommands(CommandBase command, String commandName) {
        for (Method method : command.getClass().getDeclaredMethods()) {
            int i;
            if (!method.isAnnotationPresent(Default.class) && !method.isAnnotationPresent(SubCommand.class) || !Modifier.isPublic(method.getModifiers())) continue;
            if (method.getParameterCount() == 0) {
                throw new InvalidParamException("Method " + method.getName() + " in class " + command.getClass().getName() + " - needs to have Parameters!");
            }
            if (!method.getParameterTypes()[0].getTypeName().equals(CommandSender.class.getTypeName()) && !method.getParameterTypes()[0].getTypeName().equals(Player.class.getTypeName())) {
                throw new InvalidParamException("Method " + method.getName() + " in class " + command.getClass().getName() + " - first parameter needs to be a CommandSender or a Player!");
            }
            CommandData commandData = new CommandData(command);
            commandData.setMethod(method);
            commandData.setFirstParam(method.getParameterTypes()[0]);
            if (method.isAnnotationPresent(Default.class)) {
                commandData.setDef(true);
                if (commandData.getParams().size() != 0) {
                    throw new InvalidParamException("Method " + method.getName() + " in class " + command.getClass().getName() + " - Default method cannot have more than one parameter!");
                }
            }
            for (i = 1; i < method.getParameterTypes().length; ++i) {
                Class<?> clss = method.getParameterTypes()[i];
                if (clss.equals(String[].class) && i != method.getParameterTypes().length - 1) {
                    throw new InvalidParamException("Method " + method.getName() + " in class " + command.getClass().getName() + " 'String[] args' have to be the last parameter if wants to be used!");
                }
                if (!clss.isEnum() && !this.parameterHandler.isRegisteredType(clss)) {
                    throw new InvalidParamException("Method " + method.getName() + " in class " + command.getClass().getName() + " contains unregistered parameter types!");
                }
                commandData.getParams().add(clss);
            }
            if (method.isAnnotationPresent(Permission.class)) {
                commandData.setPermission(method.getAnnotation(Permission.class).value());
            }
            for (i = 0; i < method.getParameters().length; ++i) {
                Parameter parameter = method.getParameters()[i];
                if (i == 0 && parameter.isAnnotationPresent(Completion.class)) {
                    throw new InvalidParamAnnotationException("Method " + method.getName() + " in class " + command.getClass().getName() + " - First parameter of a command method cannot have Completion annotation!");
                }
                if (parameter.getType().getTypeName().equals(String[].class.getTypeName())) {
                    if (parameter.isAnnotationPresent(MaxArgs.class)) {
                        commandData.setMaxArgs(parameter.getAnnotation(MaxArgs.class).value());
                    }
                    if (parameter.isAnnotationPresent(MinArgs.class)) {
                        commandData.setMinArgs(parameter.getAnnotation(MinArgs.class).value());
                    }
                }
                if (!parameter.isAnnotationPresent(Completion.class)) continue;
                String[] values = parameter.getAnnotation(Completion.class).value();
                if (values.length != 1) {
                    throw new InvalidParamAnnotationException("Method " + method.getName() + " in class " + command.getClass().getName() + " - Parameter completion can only have one value!");
                }
                if (!values[0].startsWith("#")) {
                    throw new InvalidCompletionIdException("Method " + method.getName() + " in class " + command.getClass().getName() + " - The completion ID must start with #!");
                }
                if (!this.completionHandler.isRegistered(values[0])) {
                    throw new InvalidCompletionIdException("Method " + method.getName() + " in class " + command.getClass().getName() + " - Unregistered completion ID '" + values[0] + "'!");
                }
                commandData.getCompletions().put(i, values[0]);
            }
            if (method.isAnnotationPresent(Completion.class)) {
                String[] completionValues = method.getAnnotation(Completion.class).value();
                for (int i2 = 0; i2 < completionValues.length; ++i2) {
                    String id = completionValues[i2];
                    if (!id.startsWith("#")) {
                        throw new InvalidCompletionIdException("Method " + method.getName() + " in class " + command.getClass().getName() + " - The completion ID must start with #!");
                    }
                    if (!this.completionHandler.isRegistered(id)) {
                        throw new InvalidCompletionIdException("Method " + method.getName() + " in class " + command.getClass().getName() + " - Unregistered completion ID'" + id + "'!");
                    }
                    commandData.getCompletions().put(i2 + 1, id);
                }
            }
            if (method.isAnnotationPresent(Alias.class)) {
                for (String alias : method.getAnnotation(Alias.class).value()) {
                    CommandData aliasCD = commandData;
                    if (aliasCD.isDef()) {
                        aliasCD.setDef(false);
                    }
                    this.subCommands.put(alias, aliasCD);
                }
            }
            if (!commandData.isDef() && method.isAnnotationPresent(SubCommand.class)) {
                this.subCommands.put(method.getAnnotation(SubCommand.class).value(), commandData);
            }
            if (!commandData.isDef()) continue;
            this.subCommands.put(commandName, commandData);
        }
    }

    public boolean execute(CommandSender sender, String label, String[] arguments) {
        if (arguments.length == 0 || arguments[0].isEmpty()) {
            CommandData commandData = this.getDefaultMethod();
            if (commandData == null) {
                return true;
            }
            if (commandData.hasPermission() && !sender.hasPermission(commandData.getPermission())) {
                this.messageHandler.sendMessage("cmd.no.permission", sender, null);
                return true;
            }
            if (!commandData.getFirstParam().getTypeName().equals(CommandSender.class.getTypeName()) && !(sender instanceof Player)) {
                this.messageHandler.sendMessage("cmd.no.console", sender, null);
                return true;
            }
            return this.executeCommand(commandData, sender, arguments, true);
        }
        CommandData commandData = this.getDefaultMethod();
        assert (commandData != null);
        if (commandData.getParams().size() == 0) {
            if (!this.subCommands.containsKey(arguments[0]) || this.getName().equalsIgnoreCase(arguments[0])) {
                this.messageHandler.sendMessage("cmd.no.exists", sender, arguments[0]);
                return true;
            }
            commandData = this.subCommands.get(arguments[0]);
        }
        if (commandData.hasPermission() && !sender.hasPermission(commandData.getPermission())) {
            this.messageHandler.sendMessage("cmd.no.permission", sender, null);
            return true;
        }
        if (!commandData.getFirstParam().getTypeName().equals(CommandSender.class.getTypeName()) && !(sender instanceof Player)) {
            this.messageHandler.sendMessage("cmd.no.console", sender, null);
            return true;
        }
        return this.executeCommand(commandData, sender, arguments, commandData.isDef());
    }

    private boolean executeCommand(CommandData commandData, CommandSender sender, String[] arguments, boolean def) {
        try {
            Method method = commandData.getMethod();
            LinkedList<String> argumentsList = new LinkedList<String>(Arrays.asList(arguments));
            if (!def && argumentsList.size() > 0) {
                argumentsList.remove(0);
            }
            if (commandData.getParams().size() == 0 && argumentsList.size() == 0) {
                method.invoke((Object)commandData.getCommand(), sender);
                return true;
            }
            if (commandData.getParams().size() == 1 && commandData.getParams().get(0).getTypeName().equals(String[].class.getTypeName())) {
                method.invoke((Object)commandData.getCommand(), sender, arguments);
                return true;
            }
            if (commandData.getParams().size() != argumentsList.size()) {
                if (!commandData.isDef() && commandData.getParams().size() == 0) {
                    this.messageHandler.sendMessage("cmd.wrong.usage", sender, null);
                    return true;
                }
                if (!commandData.getParams().get(commandData.getParams().size() - 1).getTypeName().equals(String[].class.getTypeName())) {
                    this.messageHandler.sendMessage("cmd.wrong.usage", sender, null);
                    return true;
                }
            }
            ArrayList<Object> invokeParams = new ArrayList<Object>();
            invokeParams.add(sender);
            for (int i = 0; i < commandData.getParams().size(); ++i) {
                Object result;
                Class parameter = commandData.getParams().get(i);
                if (commandData.getParams().size() > argumentsList.size()) {
                    this.messageHandler.sendMessage("cmd.wrong.usage", sender, null);
                    return true;
                }
                Object argument = argumentsList.get(i);
                if (parameter.equals(String[].class)) {
                    String[] args = new String[argumentsList.size() - i];
                    if (commandData.getMaxArgs() != 0 && args.length > commandData.getMaxArgs()) {
                        this.messageHandler.sendMessage("cmd.wrong.usage", sender, null);
                        return true;
                    }
                    if (commandData.getMinArgs() != 0 && args.length < commandData.getMinArgs()) {
                        this.messageHandler.sendMessage("cmd.wrong.usage", sender, null);
                        return true;
                    }
                    for (int j = 0; j < args.length; ++j) {
                        args[j] = (String)argumentsList.get(i + j);
                    }
                    argument = args;
                }
                if ((result = this.parameterHandler.getTypeResult(parameter, argument, sender)) == null) {
                    return true;
                }
                invokeParams.add(result);
            }
            method.invoke((Object)commandData.getCommand(), invokeParams.toArray());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        String current;
        if (args.length == 1) {
            ArrayList<String> commandNames = new ArrayList();
            ArrayList<String> subCmd = new ArrayList<String>(this.subCommands.keySet());
            subCmd.remove(this.getName());
            if (!args[0].equals("")) {
                for (String commandName : subCmd) {
                    if (!commandName.startsWith(args[0].toLowerCase())) continue;
                    commandNames.add(commandName);
                }
            } else {
                commandNames = subCmd;
            }
            Collections.sort(commandNames);
            return commandNames;
        }
        String subCommand = args[0];
        if (!this.subCommands.containsKey(subCommand)) {
            return super.tabComplete(sender, alias, args);
        }
        CommandData commandData = this.subCommands.get(subCommand);
        if (!commandData.getCompletions().containsKey(args.length - 1)) {
            return super.tabComplete(sender, alias, args);
        }
        String id = commandData.getCompletions().get(args.length - 1);
        if (!this.completionHandler.isRegistered(id)) {
            return super.tabComplete(sender, alias, args);
        }
        ArrayList<String> completionList = new ArrayList();
        Object inputClss = commandData.getParams().get(args.length - 2);
        if (id.contains(":")) {
            String[] values = id.split(":");
            id = values[0];
            inputClss = values[1];
        }
        if (!"".equals(current = args[args.length - 1])) {
            for (String completion : this.completionHandler.getTypeResult(id, inputClss)) {
                if (!completion.toLowerCase().contains(current.toLowerCase())) continue;
                completionList.add(completion);
            }
        } else {
            completionList = new ArrayList<String>(this.completionHandler.getTypeResult(id, inputClss));
        }
        Collections.sort(completionList);
        return completionList;
    }

    private CommandData getDefaultMethod() {
        for (String subCommand : this.subCommands.keySet()) {
            if (!this.subCommands.get(subCommand).isDef()) continue;
            return this.subCommands.get(subCommand);
        }
        return null;
    }
}

