/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mf.components;

import java.util.HashMap;
import java.util.Map;
import me.mattstudios.mf.components.Message;
import me.mattstudios.mf.components.MessageHandler;
import me.mattstudios.mf.components.ParameterResolver;
import me.mattstudios.mf.exceptions.InvalidArgumentException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ParameterHandler {
    private final Map<Class<?>, ParameterResolver> registeredTypes = new HashMap();
    private MessageHandler messageHandler;

    public ParameterHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.register(Short.class, (arg, type) -> {
            try {
                return this.tryParseNumber(Short.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException(Message.MUST_BE_NUMBER);
            }
        });
        this.register(Short.TYPE, (arg, type) -> {
            try {
                return this.tryParseNumber(Short.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException(Message.MUST_BE_NUMBER);
            }
        });
        this.register(Integer.TYPE, (arg, type) -> {
            try {
                return this.tryParseNumber(Integer.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException(Message.MUST_BE_NUMBER);
            }
        });
        this.register(Integer.class, (arg, type) -> {
            try {
                return this.tryParseNumber(Integer.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException(Message.MUST_BE_NUMBER);
            }
        });
        this.register(Long.TYPE, (arg, type) -> {
            try {
                return this.tryParseNumber(Long.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException(Message.MUST_BE_NUMBER);
            }
        });
        this.register(Long.class, (arg, type) -> {
            try {
                return this.tryParseNumber(Long.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException(Message.MUST_BE_NUMBER);
            }
        });
        this.register(Float.TYPE, (arg, type) -> {
            try {
                return this.tryParseNumber(Float.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException(Message.MUST_BE_NUMBER);
            }
        });
        this.register(Float.class, (arg, type) -> {
            try {
                return this.tryParseNumber(Float.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException(Message.MUST_BE_NUMBER);
            }
        });
        this.register(Double.TYPE, (arg, type) -> {
            try {
                return this.tryParseNumber(Double.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException(Message.MUST_BE_NUMBER);
            }
        });
        this.register(Double.class, (arg, type) -> {
            try {
                return this.tryParseNumber(Double.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException(Message.MUST_BE_NUMBER);
            }
        });
        this.register(String.class, (arg, type) -> {
            if (arg instanceof String) {
                return arg;
            }
            throw new InvalidArgumentException(Message.WRONG_USAGE);
        });
        this.register(String[].class, (arg, type) -> {
            if (arg instanceof String[]) {
                return arg;
            }
            throw new InvalidArgumentException(Message.WRONG_USAGE);
        });
        this.register(Player.class, (arg, type) -> {
            Player player = Bukkit.getServer().getPlayer(String.valueOf(arg));
            if (player != null) {
                return player;
            }
            throw new InvalidArgumentException(Message.MUST_BE_PLAYER);
        });
        this.register(Enum.class, (arg, type) -> {
            Class enumCls = type;
            for (Enum enumValue : (Enum[])enumCls.getEnumConstants()) {
                if (!enumValue.name().equalsIgnoreCase(String.valueOf(arg))) continue;
                return enumValue;
            }
            throw new InvalidArgumentException(Message.INVALID_VALUE);
        });
    }

    public void register(Class<?> clss, ParameterResolver parameterResolver) {
        this.registeredTypes.put(clss, parameterResolver);
    }

    public Object getTypeResult(Class<?> clss, Object object, CommandSender sender) {
        try {
            return this.registeredTypes.get(clss).getResolved(object, clss);
        }
        catch (InvalidArgumentException e) {
            this.messageHandler.sendMessage(e.getMessageEnum(), sender, String.valueOf(object));
            return null;
        }
    }

    public Object getTypeResult(Class<?> clss, Object object, CommandSender sender, Class<?> parseClass) {
        try {
            return this.registeredTypes.get(clss).getResolved(object, parseClass);
        }
        catch (InvalidArgumentException e) {
            this.messageHandler.sendMessage(e.getMessageEnum(), sender, String.valueOf(object));
            return null;
        }
    }

    public boolean isRegisteredType(Class<?> clss) {
        return this.registeredTypes.containsKey(clss);
    }

    private Number tryParseNumber(Class<?> clss, String number) throws NumberFormatException {
        switch (clss.getName()) {
            case "java.lang.Short": {
                return Short.parseShort(number);
            }
            case "java.lang.Integer": {
                return Integer.parseInt(number);
            }
            case "java.lang.Long": {
                return Long.parseLong(number);
            }
            case "java.lang.Float": {
                return Float.valueOf(Float.parseFloat(number));
            }
            case "java.lang.Double": {
                return Double.parseDouble(number);
            }
        }
        throw new NumberFormatException();
    }
}

