/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mf.components;

import java.util.HashMap;
import java.util.Map;
import me.mattstudios.mf.components.Message;
import me.mattstudios.mf.components.MessageResolver;
import me.mattstudios.mf.components.Util;
import org.bukkit.command.CommandSender;

public class MessageHandler {
    private Map<Message, MessageResolver> messages = new HashMap<Message, MessageResolver>();

    public MessageHandler() {
        this.register(Message.NO_PERMISSION, (sender, arg) -> sender.sendMessage(Util.color("&cYou don't have permission to execute this command!")));
        this.register(Message.NO_CONSOLE, (sender, arg) -> sender.sendMessage(Util.color("&cCommand can't be executed through the console!")));
        this.register(Message.DOESNT_EXISTS, (sender, arg) -> sender.sendMessage(Util.color("&cThe command you're trying to use doesn't exist!")));
        this.register(Message.WRONG_USAGE, (sender, arg) -> sender.sendMessage(Util.color("&cWrong usage for the command!")));
        this.register(Message.MUST_BE_NUMBER, (sender, arg) -> sender.sendMessage(Util.color("&c" + arg + " must be a number!")));
        this.register(Message.MUST_BE_NUMBER_DECIMAL, (sender, arg) -> sender.sendMessage(Util.color("&c" + arg + " must be a number!")));
        this.register(Message.MUST_BE_PLAYER, (sender, arg) -> sender.sendMessage(Util.color("&c" + arg + " is not a valid player!")));
        this.register(Message.INVALID_VALUE, (sender, arg) -> sender.sendMessage(Util.color("&c" + arg + " is invalid!")));
    }

    public void register(Message message, MessageResolver messageResolver) {
        this.messages.put(message, messageResolver);
    }

    public void sendMessage(Message message, CommandSender commandSender, String argument) {
        this.messages.get((Object)message).resolve(commandSender, argument);
    }
}

