/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mf.base;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.mattstudios.mf.annotations.Alias;
import me.mattstudios.mf.annotations.Command;
import me.mattstudios.mf.base.CommandBase;
import me.mattstudios.mf.base.CommandHandler;
import me.mattstudios.mf.base.CompletionHandler;
import me.mattstudios.mf.base.MessageHandler;
import me.mattstudios.mf.base.ParameterHandler;
import me.mattstudios.mf.exceptions.NoCommandException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;

public final class CommandManager
implements Listener {
    private final Plugin plugin;
    private CommandMap commandMap;
    private final Map<String, CommandHandler> commands = new HashMap<String, CommandHandler>();
    private final ParameterHandler parameterHandler = new ParameterHandler();
    private final CompletionHandler completionHandler = new CompletionHandler();
    private final MessageHandler messageHandler = new MessageHandler();
    private boolean hideTab;

    public CommandManager(Plugin plugin) {
        this(plugin, false);
    }

    public CommandManager(Plugin plugin, boolean hideTab) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
        this.hideTab = hideTab;
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            this.commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public ParameterHandler getParameterHandler() {
        return this.parameterHandler;
    }

    public CompletionHandler getCompletionHandler() {
        return this.completionHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void register(CommandBase command) {
        Class<?> commandClass = command.getClass();
        if (!commandClass.isAnnotationPresent(Command.class)) {
            throw new NoCommandException("Class " + command.getClass().getName() + " needs to have @Command!");
        }
        String commandName = commandClass.getAnnotation(Command.class).value();
        String[] aliases = new String[]{};
        if (commandClass.isAnnotationPresent(Alias.class)) {
            aliases = commandClass.getAnnotation(Alias.class).value();
        }
        try {
            if (this.commands.containsKey(commandName)) {
                this.commands.get(commandName).addSubCommands(command);
                return;
            }
            CommandHandler commandHandler = new CommandHandler(this.parameterHandler, this.completionHandler, this.messageHandler, command, commandName, Arrays.asList(aliases), this.hideTab);
            this.commandMap.register(this.plugin.getName(), (org.bukkit.command.Command)commandHandler);
            this.commands.put(commandName, commandHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideTabComplete(boolean hideTab) {
        this.hideTab = hideTab;
        for (String cmdName : this.commands.keySet()) {
            this.commands.get(cmdName).setHideTab(hideTab);
        }
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        if (!this.plugin.getName().equalsIgnoreCase(event.getPlugin().getName())) {
            return;
        }
        this.unregisterAll();
    }

    private void unregisterAll() {
        this.commands.clear();
    }
}

