/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mf.base;

import java.util.HashMap;
import java.util.Map;
import me.mattstudios.mf.base.components.CommandData;
import me.mattstudios.mf.base.components.ParameterResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class ParameterHandler {
    private final Map<Class<?>, ParameterResolver> registeredTypes = new HashMap();

    ParameterHandler() {
        this.register(Short.class, arg -> {
            try {
                return new Object[]{this.tryParseNumber(Short.class, String.valueOf(arg)), arg};
            }
            catch (NumberFormatException e) {
                return new Object[]{null, arg};
            }
        });
        this.register(Short.TYPE, arg -> {
            try {
                return new Object[]{this.tryParseNumber(Short.class, String.valueOf(arg)), arg};
            }
            catch (NumberFormatException e) {
                return new Object[]{null, arg};
            }
        });
        this.register(Integer.TYPE, arg -> {
            try {
                return new Object[]{this.tryParseNumber(Integer.class, String.valueOf(arg)), arg};
            }
            catch (NumberFormatException e) {
                return new Object[]{null, arg};
            }
        });
        this.register(Integer.class, arg -> {
            try {
                return new Object[]{this.tryParseNumber(Integer.class, String.valueOf(arg)), arg};
            }
            catch (NumberFormatException e) {
                return new Object[]{null, arg};
            }
        });
        this.register(Long.TYPE, arg -> {
            try {
                return new Object[]{this.tryParseNumber(Long.class, String.valueOf(arg)), arg};
            }
            catch (NumberFormatException e) {
                return new Object[]{null, arg};
            }
        });
        this.register(Long.class, arg -> {
            try {
                return new Object[]{this.tryParseNumber(Long.class, String.valueOf(arg)), arg};
            }
            catch (NumberFormatException e) {
                return new Object[]{null, arg};
            }
        });
        this.register(Float.TYPE, arg -> {
            try {
                return new Object[]{this.tryParseNumber(Float.class, String.valueOf(arg)), arg};
            }
            catch (NumberFormatException e) {
                return new Object[]{null, arg};
            }
        });
        this.register(Float.class, arg -> {
            try {
                return new Object[]{this.tryParseNumber(Float.class, String.valueOf(arg)), arg};
            }
            catch (NumberFormatException e) {
                return new Object[]{null, arg};
            }
        });
        this.register(Double.TYPE, arg -> {
            try {
                return new Object[]{this.tryParseNumber(Double.class, String.valueOf(arg)), arg};
            }
            catch (NumberFormatException e) {
                return new Object[]{null, arg};
            }
        });
        this.register(Double.class, arg -> {
            try {
                return new Object[]{this.tryParseNumber(Double.class, String.valueOf(arg)), arg};
            }
            catch (NumberFormatException e) {
                return new Object[]{null, arg};
            }
        });
        this.register(String.class, arg -> {
            if (arg instanceof String) {
                return new Object[]{arg, arg};
            }
            return new Object[]{null, arg};
        });
        this.register(String[].class, arg -> {
            if (arg instanceof String[]) {
                return new Object[]{arg, arg};
            }
            return new Object[]{null, arg};
        });
        this.register(Player.class, arg -> {
            Player player = Bukkit.getPlayer((String)String.valueOf(arg));
            if (player != null) {
                return new Object[]{player, arg};
            }
            return new Object[]{null, arg};
        });
        this.register(Material.class, arg -> {
            Material material = Material.matchMaterial((String)String.valueOf(arg));
            if (material != null) {
                return new Object[]{material, arg};
            }
            return new Object[]{null, arg};
        });
    }

    public void register(Class<?> clss, ParameterResolver parameterResolver) {
        this.registeredTypes.put(clss, parameterResolver);
    }

    Object getTypeResult(Class<?> clss, Object object, CommandData subCommand, String paramName) {
        Object[] registeredObjects = this.registeredTypes.get(clss).getResolved(object);
        subCommand.getCommandBase().addArgument(paramName, String.valueOf(registeredObjects[1]));
        return registeredObjects[0];
    }

    boolean isRegisteredType(Class<?> clss) {
        return this.registeredTypes.containsKey(clss);
    }

    private Number tryParseNumber(Class<?> clss, String number) throws NumberFormatException {
        switch (clss.getName()) {
            case "java.lang.Short": {
                return Short.parseShort(number);
            }
            case "java.lang.Integer": {
                return Integer.parseInt(number);
            }
            case "java.lang.Long": {
                return Long.parseLong(number);
            }
            case "java.lang.Float": {
                return Float.valueOf(Float.parseFloat(number));
            }
            case "java.lang.Double": {
                return Double.parseDouble(number);
            }
        }
        throw new NumberFormatException();
    }
}

