/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mf.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.mattstudios.mf.base.components.CompletionResolver;
import me.mattstudios.mf.exceptions.InvalidCompletionIdException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class CompletionHandler {
    private final Map<String, CompletionResolver> registeredCompletions = new HashMap<String, CompletionResolver>();

    CompletionHandler() {
        this.register("#players", input -> {
            ArrayList<String> players = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.add(player.getName());
            }
            players.sort(String.CASE_INSENSITIVE_ORDER);
            return players;
        });
        this.register("#empty", input -> Collections.singletonList(""));
        this.register("#range", input -> {
            String s = String.valueOf(input);
            if (s.equalsIgnoreCase("int") || s.equalsIgnoreCase("double") || s.equalsIgnoreCase("float")) {
                return IntStream.rangeClosed(1, 10).mapToObj(Integer::toString).collect(Collectors.toList());
            }
            if (!s.contains("-")) {
                return IntStream.rangeClosed(1, Integer.parseInt(s)).mapToObj(Integer::toString).collect(Collectors.toList());
            }
            String[] minMax = s.split("-");
            int[] range = IntStream.rangeClosed(Integer.parseInt(minMax[0]), Integer.parseInt(minMax[1])).toArray();
            ArrayList<String> rangeList = new ArrayList<String>();
            for (int number : range) {
                rangeList.add(String.valueOf(number));
            }
            return rangeList;
        });
        this.register("#enum", input -> {
            Class enumCls = (Class)input;
            ArrayList<String> values = new ArrayList<String>();
            for (Enum enumValue : (Enum[])enumCls.getEnumConstants()) {
                values.add(enumValue.name());
            }
            values.sort(String.CASE_INSENSITIVE_ORDER);
            return values;
        });
    }

    public void register(String completionId, CompletionResolver completionResolver) {
        if (!completionId.startsWith("#")) {
            throw new InvalidCompletionIdException("Could not register completion, id - " + completionId + " does not start with #.");
        }
        this.registeredCompletions.put(completionId, completionResolver);
    }

    List<String> getTypeResult(String completionId, Object input) {
        return this.registeredCompletions.get(completionId).resolve(input);
    }

    boolean isRegistered(String completionId) {
        String completionContent = "";
        if (completionId.contains(":")) {
            String[] content = completionId.split(":");
            completionContent = content[0];
        }
        return this.registeredCompletions.containsKey(completionContent);
    }
}

