/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mf.base;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.mattstudios.mf.annotations.Alias;
import me.mattstudios.mf.annotations.Completion;
import me.mattstudios.mf.annotations.Default;
import me.mattstudios.mf.annotations.MaxArgs;
import me.mattstudios.mf.annotations.MinArgs;
import me.mattstudios.mf.annotations.Optional;
import me.mattstudios.mf.annotations.Permission;
import me.mattstudios.mf.annotations.SubCommand;
import me.mattstudios.mf.base.CommandBase;
import me.mattstudios.mf.base.CompletionHandler;
import me.mattstudios.mf.base.MessageHandler;
import me.mattstudios.mf.base.ParameterHandler;
import me.mattstudios.mf.base.components.CommandData;
import me.mattstudios.mf.exceptions.InvalidCompletionIdException;
import me.mattstudios.mf.exceptions.InvalidParamAnnotationException;
import me.mattstudios.mf.exceptions.InvalidParamException;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class CommandHandler
extends Command {
    private final Map<String, CommandData> commands;
    private final ParameterHandler parameterHandler;
    private final CompletionHandler completionHandler;
    private final MessageHandler messageHandler;
    private boolean hideTab;

    CommandHandler(ParameterHandler parameterHandler, CompletionHandler completionHandler, MessageHandler messageHandler, CommandBase command, String commandName, List<String> aliases) {
        super(commandName);
        this.parameterHandler = parameterHandler;
        this.completionHandler = completionHandler;
        this.messageHandler = messageHandler;
        this.setAliases(aliases);
        this.commands = new HashMap<String, CommandData>();
        this.addSubCommands(command);
    }

    void addSubCommands(CommandBase command) {
        for (Method method : command.getClass().getDeclaredMethods()) {
            CommandData subCommand = new CommandData(command);
            if (!method.isAnnotationPresent(Default.class) && !method.isAnnotationPresent(SubCommand.class) || !Modifier.isPublic(method.getModifiers())) continue;
            if (method.getParameterCount() == 0) {
                throw new InvalidParamException("Method " + method.getName() + " in class " + command.getClass().getName() + " - needs to have Parameters!");
            }
            if (!method.getParameterTypes()[0].getTypeName().equals(CommandSender.class.getTypeName()) && !method.getParameterTypes()[0].getTypeName().equals(Player.class.getTypeName())) {
                throw new InvalidParamException("Method " + method.getName() + " in class " + command.getClass().getName() + " - first parameter needs to be a CommandSender or a Player!");
            }
            subCommand.setMethod(method);
            subCommand.setFirstParam(method.getParameterTypes()[0]);
            this.checkRegisteredParams(method, command, subCommand);
            this.checkDefault(method, subCommand);
            this.checkPermission(method, subCommand);
            this.checkOptionalParam(method, command, subCommand);
            this.checkParamCompletion(method, command, subCommand);
            this.checkMethodCompletion(method, command, subCommand);
            this.checkAlias(method, subCommand);
            if (!subCommand.isDefault() && method.isAnnotationPresent(SubCommand.class)) {
                this.commands.put(method.getAnnotation(SubCommand.class).value().toLowerCase(), subCommand);
            }
            if (!subCommand.isDefault()) continue;
            this.commands.put("default", subCommand);
        }
    }

    public boolean execute(CommandSender sender, String label, String[] arguments) {
        CommandData subCommand = this.getDefaultSubCommand();
        if (arguments.length == 0 || arguments[0].isEmpty()) {
            if (subCommand == null) {
                this.messageHandler.sendMessage("cmd.no.exists", sender);
                return true;
            }
            if (subCommand.hasPermission() && !sender.hasPermission(subCommand.getPermission())) {
                this.messageHandler.sendMessage("cmd.no.permission", sender);
                return true;
            }
            if (!subCommand.getFirstParam().getTypeName().equals(CommandSender.class.getTypeName()) && !(sender instanceof Player)) {
                this.messageHandler.sendMessage("cmd.no.console", sender);
                return true;
            }
            return this.executeCommand(subCommand, sender, arguments);
        }
        String argCommand = arguments[0].toLowerCase();
        if (subCommand != null && subCommand.getParams().size() == 0 && (!this.commands.containsKey(argCommand) || this.getName().equalsIgnoreCase(argCommand))) {
            this.messageHandler.sendMessage("cmd.no.exists", sender);
            return true;
        }
        if (subCommand == null && !this.commands.containsKey(argCommand)) {
            this.messageHandler.sendMessage("cmd.no.exists", sender);
            return true;
        }
        if (this.commands.containsKey(argCommand)) {
            subCommand = this.commands.get(argCommand);
        }
        assert (subCommand != null);
        if (subCommand.hasPermission() && !sender.hasPermission(subCommand.getPermission())) {
            this.messageHandler.sendMessage("cmd.no.permission", sender);
            return true;
        }
        if (!subCommand.getFirstParam().getTypeName().equals(CommandSender.class.getTypeName()) && !(sender instanceof Player)) {
            this.messageHandler.sendMessage("cmd.no.console", sender);
            return true;
        }
        return this.executeCommand(subCommand, sender, arguments);
    }

    private boolean executeCommand(CommandData subCommand, CommandSender sender, String[] arguments) {
        try {
            Method method = subCommand.getMethod();
            LinkedList<String> argumentsList = new LinkedList<String>(Arrays.asList(arguments));
            if (!subCommand.isDefault() && argumentsList.size() > 0) {
                argumentsList.remove(0);
            }
            if (subCommand.getParams().size() == 0 && argumentsList.size() == 0) {
                method.invoke((Object)subCommand.getCommandBase(), sender);
                return true;
            }
            if (subCommand.getParams().size() == 1 && subCommand.getParams().get(0).getTypeName().equals(String[].class.getTypeName())) {
                method.invoke((Object)subCommand.getCommandBase(), sender, arguments);
                return true;
            }
            if (subCommand.getParams().size() != argumentsList.size() && !subCommand.hasOptional()) {
                if (!subCommand.isDefault() && subCommand.getParams().size() == 0) {
                    return this.wrongUsage(sender);
                }
                if (!subCommand.getParams().get(subCommand.getParams().size() - 1).getTypeName().equals(String[].class.getTypeName())) {
                    return this.wrongUsage(sender);
                }
            }
            ArrayList<Object> invokeParams = new ArrayList<Object>();
            invokeParams.add(sender);
            for (int i = 0; i < subCommand.getParams().size(); ++i) {
                Class<?> parameter = subCommand.getParams().get(i);
                if (subCommand.hasOptional()) {
                    if (argumentsList.size() > subCommand.getParams().size()) {
                        return this.wrongUsage(sender);
                    }
                    if (argumentsList.size() < subCommand.getParams().size() - 1) {
                        return this.wrongUsage(sender);
                    }
                    if (argumentsList.size() < subCommand.getParams().size()) {
                        argumentsList.add(null);
                    }
                }
                if (subCommand.getParams().size() > argumentsList.size()) {
                    return this.wrongUsage(sender);
                }
                Object argument = argumentsList.get(i);
                if (parameter.equals(String[].class)) {
                    String[] args = new String[argumentsList.size() - i];
                    if (subCommand.getMaxArgs() != 0 && args.length > subCommand.getMaxArgs()) {
                        this.messageHandler.sendMessage("cmd.wrong.usage", sender);
                        return true;
                    }
                    if (subCommand.getMinArgs() != 0 && args.length < subCommand.getMinArgs()) {
                        this.messageHandler.sendMessage("cmd.wrong.usage", sender);
                        return true;
                    }
                    for (int j = 0; j < args.length; ++j) {
                        args[j] = (String)argumentsList.get(i + j);
                    }
                    argument = args;
                }
                Object result = this.parameterHandler.getTypeResult(parameter, argument, subCommand, subCommand.getParameterNames().get(i));
                invokeParams.add(result);
            }
            method.invoke((Object)subCommand.getCommandBase(), invokeParams.toArray());
            subCommand.getCommandBase().clearArgs();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        String current;
        if (args.length == 1) {
            ArrayList<Object> commandNames = new ArrayList();
            CommandData subCommand = this.getDefaultSubCommand();
            ArrayList<String> subCmd = new ArrayList<String>(this.commands.keySet());
            subCmd.remove("default");
            for (String subCmdName : this.commands.keySet()) {
                CommandData subCmdData = this.commands.get(subCmdName);
                if (!this.hideTab || !subCmdData.hasPermission() || sender.hasPermission(subCmdData.getPermission())) continue;
                subCmd.remove(subCmdName);
            }
            if (subCommand != null && subCommand.getCompletions().size() != 0) {
                Object id = subCommand.getCompletions().get(1);
                Object inputClss = subCommand.getParams().get(0);
                if (((String)id).contains(":")) {
                    String[] values = ((String)id).split(":");
                    id = values[0];
                    inputClss = values[1];
                }
                subCmd.addAll(this.completionHandler.getTypeResult((String)id, inputClss));
            }
            if (!args[0].equals("")) {
                for (String commandName : subCmd) {
                    if (!commandName.startsWith(args[0].toLowerCase())) continue;
                    commandNames.add(commandName);
                }
            } else {
                commandNames = subCmd;
            }
            Collections.sort(commandNames);
            if (commandNames.isEmpty()) {
                return super.tabComplete(sender, alias, args);
            }
            return commandNames;
        }
        String subCommandArg = args[0];
        if (!this.commands.containsKey(subCommandArg)) {
            return super.tabComplete(sender, alias, args);
        }
        CommandData subCommand = this.commands.get(subCommandArg);
        if (this.hideTab && subCommand.hasPermission() && !sender.hasPermission(subCommand.getPermission())) {
            return super.tabComplete(sender, alias, args);
        }
        if (!subCommand.getCompletions().containsKey(args.length - 1)) {
            return super.tabComplete(sender, alias, args);
        }
        String id = subCommand.getCompletions().get(args.length - 1);
        if (!this.completionHandler.isRegistered(id)) {
            return super.tabComplete(sender, alias, args);
        }
        ArrayList<String> completionList = new ArrayList();
        Object inputClss = subCommand.getParams().get(args.length - 2);
        if (id.contains(":")) {
            String[] values = id.split(":");
            id = values[0];
            inputClss = values[1];
        }
        if (!"".equals(current = args[args.length - 1])) {
            for (String completion : this.completionHandler.getTypeResult(id, inputClss)) {
                if (!completion.toLowerCase().contains(current.toLowerCase())) continue;
                completionList.add(completion);
            }
        } else {
            completionList = new ArrayList<String>(this.completionHandler.getTypeResult(id, inputClss));
        }
        Collections.sort(completionList);
        return completionList;
    }

    public void setHideTab(boolean hideTab) {
        this.hideTab = hideTab;
    }

    private CommandData getDefaultSubCommand() {
        return this.commands.getOrDefault("default", null);
    }

    private void checkDefault(Method method, CommandData subCommand) {
        if (method.isAnnotationPresent(Default.class)) {
            subCommand.setDefault(true);
        }
    }

    private void checkRegisteredParams(Method method, CommandBase command, CommandData subCommand) {
        for (int i = 1; i < method.getParameterTypes().length; ++i) {
            Class<?> clss = method.getParameterTypes()[i];
            if (clss.equals(String[].class) && i != method.getParameterTypes().length - 1) {
                throw new InvalidParamException("Method " + method.getName() + " in class " + command.getClass().getName() + " 'String[] args' have to be the last parameter if wants to be used!");
            }
            if (!clss.isEnum() && !this.parameterHandler.isRegisteredType(clss)) {
                throw new InvalidParamException("Method " + method.getName() + " in class " + command.getClass().getName() + " contains unregistered parameter types!");
            }
            subCommand.getParams().add(clss);
            subCommand.getParameterNames().add(method.getParameters()[i].getName());
        }
    }

    private void checkPermission(Method method, CommandData subCommand) {
        if (method.isAnnotationPresent(Permission.class)) {
            subCommand.setPermission(method.getAnnotation(Permission.class).value());
        }
    }

    private void checkParamCompletion(Method method, CommandBase command, CommandData subCommand) {
        for (int i = 0; i < method.getParameters().length; ++i) {
            Parameter parameter = method.getParameters()[i];
            if (i == 0 && parameter.isAnnotationPresent(Completion.class)) {
                throw new InvalidParamAnnotationException("Method " + method.getName() + " in class " + command.getClass().getName() + " - First parameter of a command method cannot have Completion annotation!");
            }
            if (parameter.getType().getTypeName().equals(String[].class.getTypeName())) {
                if (parameter.isAnnotationPresent(MaxArgs.class)) {
                    subCommand.setMaxArgs(parameter.getAnnotation(MaxArgs.class).value());
                }
                if (parameter.isAnnotationPresent(MinArgs.class)) {
                    subCommand.setMinArgs(parameter.getAnnotation(MinArgs.class).value());
                }
            }
            if (!parameter.isAnnotationPresent(Completion.class)) continue;
            String[] values = parameter.getAnnotation(Completion.class).value();
            if (values.length != 1) {
                throw new InvalidParamAnnotationException("Method " + method.getName() + " in class " + command.getClass().getName() + " - Parameter completion can only have one value!");
            }
            if (!values[0].startsWith("#")) {
                throw new InvalidCompletionIdException("Method " + method.getName() + " in class " + command.getClass().getName() + " - The completion ID must start with #!");
            }
            if (!this.completionHandler.isRegistered(values[0])) {
                throw new InvalidCompletionIdException("Method " + method.getName() + " in class " + command.getClass().getName() + " - Unregistered completion ID '" + values[0] + "'!");
            }
            subCommand.getCompletions().put(i, values[0]);
        }
    }

    private void checkMethodCompletion(Method method, CommandBase command, CommandData subCommand) {
        if (method.isAnnotationPresent(Completion.class)) {
            String[] completionValues = method.getAnnotation(Completion.class).value();
            for (int i = 0; i < completionValues.length; ++i) {
                String id = completionValues[i];
                if (!id.startsWith("#")) {
                    throw new InvalidCompletionIdException("Method " + method.getName() + " in class " + command.getClass().getName() + " - The completion ID must start with #!");
                }
                if (!this.completionHandler.isRegistered(id)) {
                    throw new InvalidCompletionIdException("Method " + method.getName() + " in class " + command.getClass().getName() + " - Unregistered completion ID'" + id + "'!");
                }
                subCommand.getCompletions().put(i + 1, id);
            }
        }
    }

    private void checkAlias(Method method, CommandData subCommand) {
        if (method.isAnnotationPresent(Alias.class)) {
            for (String alias : method.getAnnotation(Alias.class).value()) {
                CommandData aliasCD = subCommand;
                if (aliasCD.isDefault()) {
                    aliasCD.setDefault(false);
                }
                this.commands.put(alias.toLowerCase(), subCommand);
            }
        }
    }

    private void checkOptionalParam(Method method, CommandBase command, CommandData subCommand) {
        for (int i = 0; i < method.getParameters().length; ++i) {
            Parameter parameter = method.getParameters()[i];
            if (i != method.getParameters().length - 1 && parameter.isAnnotationPresent(Optional.class)) {
                throw new InvalidParamAnnotationException("Method " + method.getName() + " in class " + command.getClass().getName() + " - Optional parameters can only be used as the last parameter of a method!");
            }
            if (!parameter.isAnnotationPresent(Optional.class)) continue;
            subCommand.setOptional(true);
        }
    }

    private boolean wrongUsage(CommandSender sender) {
        this.messageHandler.sendMessage("cmd.wrong.usage", sender);
        return true;
    }
}

