package me.mattstudios.mattscore;

import me.mattstudios.mf.base.CommandManager;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class MattPlugin extends JavaPlugin {

    protected CommandManager commandManager;
    // Config here
    //private

    public abstract void onPluginLoad();

    public abstract void onPluginEnable();

    public abstract void onPluginDisable();

    @Override
    public final void onLoad() {
        onPluginLoad();
    }

    @Override
    public final void onEnable() {
        commandManager = new CommandManager(this);
        onPluginEnable();
    }


    @Override
    public void onDisable() {
        onPluginDisable();
    }
}
