package me.matsumo.fankt.domain.model.db

import androidx.room.InvalidationTracker
import androidx.room.RoomOpenDelegate
import androidx.room.migration.AutoMigrationSpec
import androidx.room.migration.Migration
import androidx.room.util.TableInfo
import androidx.room.util.TableInfo.Companion.read
import androidx.room.util.dropFtsSyncTriggers
import androidx.sqlite.SQLiteConnection
import androidx.sqlite.execSQL
import kotlin.Lazy
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.collections.MutableList
import kotlin.collections.MutableMap
import kotlin.collections.MutableSet
import kotlin.collections.Set
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf
import kotlin.collections.mutableSetOf
import kotlin.reflect.KClass
import me.matsumo.fankt.datasource.db.CookieDao
import me.matsumo.fankt.datasource.db.CookieDao_Impl
import me.matsumo.fankt.datasource.db.TokenDao
import me.matsumo.fankt.datasource.db.TokenDao_Impl

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
internal class FanktDatabase_Impl : FanktDatabase() {
  private val _cookieDao: Lazy<CookieDao> = lazy {
    CookieDao_Impl(this)
  }

  private val _tokenDao: Lazy<TokenDao> = lazy {
    TokenDao_Impl(this)
  }

  protected override fun createOpenDelegate(): RoomOpenDelegate {
    val _openDelegate: RoomOpenDelegate = object : RoomOpenDelegate(1,
        "5fd12d23ba5964c4d162592bba999a08", "455adc2e37b0faf772e44452e7057475") {
      public override fun createAllTables(connection: SQLiteConnection) {
        connection.execSQL("CREATE TABLE IF NOT EXISTS `fankt_cookies` (`id` TEXT NOT NULL, `domain` TEXT NOT NULL, `path` TEXT NOT NULL, `name` TEXT NOT NULL, `value` TEXT NOT NULL, `expiresAt` INTEGER NOT NULL, PRIMARY KEY(`id`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `fankt_csrf_tokens` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `value` TEXT NOT NULL, `createdAt` INTEGER NOT NULL)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)")
        connection.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '5fd12d23ba5964c4d162592bba999a08')")
      }

      public override fun dropAllTables(connection: SQLiteConnection) {
        connection.execSQL("DROP TABLE IF EXISTS `fankt_cookies`")
        connection.execSQL("DROP TABLE IF EXISTS `fankt_csrf_tokens`")
      }

      public override fun onCreate(connection: SQLiteConnection) {
      }

      public override fun onOpen(connection: SQLiteConnection) {
        internalInitInvalidationTracker(connection)
      }

      public override fun onPreMigrate(connection: SQLiteConnection) {
        dropFtsSyncTriggers(connection)
      }

      public override fun onPostMigrate(connection: SQLiteConnection) {
      }

      public override fun onValidateSchema(connection: SQLiteConnection):
          RoomOpenDelegate.ValidationResult {
        val _columnsFanktCookies: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsFanktCookies.put("id", TableInfo.Column("id", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsFanktCookies.put("domain", TableInfo.Column("domain", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsFanktCookies.put("path", TableInfo.Column("path", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsFanktCookies.put("name", TableInfo.Column("name", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsFanktCookies.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsFanktCookies.put("expiresAt", TableInfo.Column("expiresAt", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysFanktCookies: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesFanktCookies: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoFanktCookies: TableInfo = TableInfo("fankt_cookies", _columnsFanktCookies,
            _foreignKeysFanktCookies, _indicesFanktCookies)
        val _existingFanktCookies: TableInfo = read(connection, "fankt_cookies")
        if (!_infoFanktCookies.equals(_existingFanktCookies)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |fankt_cookies(me.matsumo.fankt.domain.model.db.CookieEntity).
              | Expected:
              |""".trimMargin() + _infoFanktCookies + """
              |
              | Found:
              |""".trimMargin() + _existingFanktCookies)
        }
        val _columnsFanktCsrfTokens: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsFanktCsrfTokens.put("id", TableInfo.Column("id", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsFanktCsrfTokens.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsFanktCsrfTokens.put("createdAt", TableInfo.Column("createdAt", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysFanktCsrfTokens: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesFanktCsrfTokens: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoFanktCsrfTokens: TableInfo = TableInfo("fankt_csrf_tokens",
            _columnsFanktCsrfTokens, _foreignKeysFanktCsrfTokens, _indicesFanktCsrfTokens)
        val _existingFanktCsrfTokens: TableInfo = read(connection, "fankt_csrf_tokens")
        if (!_infoFanktCsrfTokens.equals(_existingFanktCsrfTokens)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |fankt_csrf_tokens(me.matsumo.fankt.domain.model.db.CSRFToken).
              | Expected:
              |""".trimMargin() + _infoFanktCsrfTokens + """
              |
              | Found:
              |""".trimMargin() + _existingFanktCsrfTokens)
        }
        return RoomOpenDelegate.ValidationResult(true, null)
      }
    }
    return _openDelegate
  }

  protected override fun createInvalidationTracker(): InvalidationTracker {
    val _shadowTablesMap: MutableMap<String, String> = mutableMapOf()
    val _viewTables: MutableMap<String, Set<String>> = mutableMapOf()
    return InvalidationTracker(this, _shadowTablesMap, _viewTables, "fankt_cookies",
        "fankt_csrf_tokens")
  }

  protected override fun getRequiredTypeConverterClasses(): Map<KClass<*>, List<KClass<*>>> {
    val _typeConvertersMap: MutableMap<KClass<*>, List<KClass<*>>> = mutableMapOf()
    _typeConvertersMap.put(CookieDao::class, CookieDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(TokenDao::class, TokenDao_Impl.getRequiredConverters())
    return _typeConvertersMap
  }

  public override fun getRequiredAutoMigrationSpecClasses(): Set<KClass<out AutoMigrationSpec>> {
    val _autoMigrationSpecsSet: MutableSet<KClass<out AutoMigrationSpec>> = mutableSetOf()
    return _autoMigrationSpecsSet
  }

  public override
      fun createAutoMigrations(autoMigrationSpecs: Map<KClass<out AutoMigrationSpec>, AutoMigrationSpec>):
      List<Migration> {
    val _autoMigrations: MutableList<Migration> = mutableListOf()
    return _autoMigrations
  }

  public override fun cookieDao(): CookieDao = _cookieDao.value

  public override fun tokenDao(): TokenDao = _tokenDao.value
}
