/*
 * Decompiled with CFR 0.152.
 */
package com.mario6.common.db.mapper;

import com.mario6.common.db.mapper.RowMapper;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class MapRowMapper
implements RowMapper<Map<String, Object>> {
    private static MapRowMapper instance = new MapRowMapper();

    public static MapRowMapper newInstance() {
        return instance;
    }

    private MapRowMapper() {
    }

    @Override
    public Map<String, Object> rowMap(ResultSet rs) throws SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            String columnName = metaData.getColumnName(i);
            Object columnValue = rs.getObject(i);
            result.put(columnName, columnValue);
        }
        return result;
    }
}

