/*
 * Decompiled with CFR 0.152.
 */
package com.mario6.common.db.mapper;

import com.mario6.common.db.util.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

public class ClassInfo<T> {
    private ClassOnlyInfo classInfo;
    private FieldInfo idFieldInfo;
    private List<FieldInfo> otherFieldsInfo;
    private static ConcurrentHashMap<Class, ClassInfo> cache = new ConcurrentHashMap();

    private ClassInfo(Class<T> clazz, boolean fastFailed) {
        this.classInfo = new ClassOnlyInfo(clazz);
        Field[] fields = clazz.getDeclaredFields();
        this.otherFieldsInfo = new ArrayList<FieldInfo>(fields.length);
        boolean isId = false;
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            Id annotation = field.getAnnotation(Id.class);
            if (annotation != null && !isId) {
                this.setIdField(field);
                isId = true;
                continue;
            }
            this.addOtherFields(field);
        }
        if (!isId && fastFailed) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u672a\u6807\u793a@Id\u4e3b\u952e\u5b57\u6bb5 " + clazz.getName());
        }
    }

    public static <T> ClassInfo newInstance(Class<T> clazz, boolean fastFailed) {
        ClassInfo<T> classInfo = cache.get(clazz);
        if (classInfo == null) {
            classInfo = new ClassInfo<T>(clazz, fastFailed);
            cache.put(clazz, classInfo);
        } else if (fastFailed && classInfo.idFieldInfo == null) {
            throw new IllegalStateException("Id\u5b57\u6bb5\u672a\u6807\u793a");
        }
        return classInfo;
    }

    public static <T> ClassInfo newInstance(Class<T> clazz) {
        return ClassInfo.newInstance(clazz, true);
    }

    public List<String> getInsertColumns(boolean snake) {
        return this.doGetInsertColumns(null, false, snake);
    }

    public List<String> getInsertColumnsSelective(T obj, boolean snake) {
        return this.doGetInsertColumns(obj, true, snake);
    }

    private List<String> doGetInsertColumns(T obj, boolean selective, boolean snake) {
        ArrayList<String> results = new ArrayList<String>(this.otherFieldsInfo.size());
        List<FieldInfo> otherFieldsInfo = this.otherFieldsInfo;
        for (int i = 0; i < otherFieldsInfo.size(); ++i) {
            FieldInfo fieldInfo = otherFieldsInfo.get(i);
            if (fieldInfo.isTransient() || selective && fieldInfo.getValue(obj) == null) continue;
            results.add(fieldInfo.getName(snake));
        }
        return results;
    }

    public List<Object> getInsertValues(T obj) {
        return this.doGetInsertValues(obj, false);
    }

    public List<Object> getInsertValuesSelective(T obj) {
        return this.doGetInsertValues(obj, true);
    }

    private List<Object> doGetInsertValues(T obj, boolean selective) {
        ArrayList<Object> results = new ArrayList<Object>(this.otherFieldsInfo.size() + 1);
        List<FieldInfo> otherFieldsInfo = this.otherFieldsInfo;
        for (int i = 0; i < otherFieldsInfo.size(); ++i) {
            FieldInfo fieldInfo = otherFieldsInfo.get(i);
            if (fieldInfo.isTransient() || selective && fieldInfo.getValue(obj) == null) continue;
            results.add(fieldInfo.getValue(obj));
        }
        return results;
    }

    public String getTableName(boolean snake) {
        String nameInTable = this.classInfo.getNameInTable();
        if (nameInTable != null) {
            return nameInTable;
        }
        if (snake) {
            return this.classInfo.getSnakeClassName();
        }
        return this.classInfo.getClassName();
    }

    public String getIdName(boolean snake) {
        this.checkIdInfo();
        FieldInfo field = this.idFieldInfo;
        String columnName = field.getColumnName();
        if (columnName != null) {
            return columnName;
        }
        if (snake) {
            return field.getSnakeName();
        }
        return field.getFieldName();
    }

    public Object getIdValue(T t) {
        this.checkIdInfo();
        return this.idFieldInfo.getValue(t);
    }

    public void setIdValue(T obj, Object o) {
        this.checkIdInfo();
        this.idFieldInfo.setValue(obj, o);
    }

    public void checkIdInfo() {
        if (this.idFieldInfo == null) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u672a\u6807\u793a@Id\u4e3b\u952e\u5b57\u6bb5 " + this.classInfo.getClazz().getName());
        }
    }

    public String getUpdateSetSqlSnippet(boolean snake) {
        return this.doGetUpdateSetSqlSnippet(null, false, snake);
    }

    public String getUpdateSetSqlSnippetSelective(T obj, boolean snake) {
        return this.doGetUpdateSetSqlSnippet(obj, true, snake);
    }

    public String doGetUpdateSetSqlSnippet(T obj, boolean selective, boolean snake) {
        ArrayList<String> setList = new ArrayList<String>(this.otherFieldsInfo.size());
        for (FieldInfo field : this.otherFieldsInfo) {
            if (field.isTransient() || selective && field.getValue(obj) == null) continue;
            String key = field.getName(snake);
            String set = key + "=?";
            setList.add(set);
        }
        return Utils.join(",", setList);
    }

    public List<Object> getUpdateSetValues(T obj) {
        return this.doGetUpdateSetValues(obj, false);
    }

    public List<Object> getUpdateSetValuesSelective(T obj) {
        return this.doGetUpdateSetValues(obj, true);
    }

    private List<Object> doGetUpdateSetValues(T obj, boolean selective) {
        ArrayList<Object> results = new ArrayList<Object>(this.otherFieldsInfo.size());
        for (FieldInfo field : this.otherFieldsInfo) {
            if (field.isTransient() || selective && field.getValue(obj) == null) continue;
            Object value = field.getValue(obj);
            results.add(value);
        }
        return results;
    }

    public List<FieldInfo> getFieldsInfo() {
        ArrayList<FieldInfo> results = new ArrayList<FieldInfo>(this.otherFieldsInfo);
        results.add(this.idFieldInfo);
        return results;
    }

    public T createByDefaultConstructor() {
        Constructor<?>[] constructors;
        Class clazz = this.classInfo.getClazz();
        T obj = null;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            constructor.setAccessible(true);
            int count = constructor.getParameterTypes().length;
            if (count != 0) continue;
            try {
                obj = (T)constructor.newInstance(new Object[0]);
                break;
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("\u5bf9\u5e94\u5b9e\u4f53\u7c7b\u578b\u6ca1\u6709\u65e0\u53c2\u6784\u9020\u51fd\u6570" + clazz.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("\u5bf9\u5e94\u5b9e\u4f53\u7c7b\u578b\u6ca1\u6709\u65e0\u53c2\u6784\u9020\u51fd\u6570" + clazz.getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("\u5bf9\u5e94\u5b9e\u4f53\u7c7b\u578b\u6ca1\u6709\u65e0\u53c2\u6784\u9020\u51fd\u6570" + clazz.getName(), e);
            }
        }
        if (obj == null) {
            throw new IllegalStateException("\u6ca1\u6709\u65e0\u53c2\u6784\u9020\u65b9\u6cd5" + clazz.getName());
        }
        return obj;
    }

    private void setIdField(Field id) {
        this.idFieldInfo = new FieldInfo(id);
    }

    private void addOtherFields(Field other) {
        FieldInfo fieldInfo = new FieldInfo(other);
        this.otherFieldsInfo.add(fieldInfo);
    }

    public Class getIdType() {
        return this.idFieldInfo.getType();
    }

    public class FieldInfo {
        private Field field;
        private Class type;
        private String fieldName;
        private String snakeName;
        private String columnName;
        private boolean transients;

        public FieldInfo(Field field) {
            this.field = field;
            this.doExtractField(this.field);
        }

        public String getName(boolean snake) {
            if (this.columnName != null) {
                return this.columnName;
            }
            if (snake) {
                return this.snakeName;
            }
            return this.fieldName;
        }

        private void doExtractField(Field field) {
            Transient transientAno;
            field.setAccessible(true);
            this.type = field.getType();
            this.fieldName = field.getName();
            this.snakeName = Utils.camelToSnake(this.fieldName);
            Column annotation = field.getAnnotation(Column.class);
            if (annotation != null) {
                this.columnName = annotation.name();
            }
            this.transients = (transientAno = field.getAnnotation(Transient.class)) != null;
        }

        public Field getField() {
            return this.field;
        }

        public Class getType() {
            return this.type;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getSnakeName() {
            return this.snakeName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean isTransient() {
            return this.transients;
        }

        public Object getValue(Object obj) {
            try {
                return this.field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public void setValue(T t, Object o) {
            try {
                this.field.set(t, o);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    class ClassOnlyInfo {
        private Class clazz;
        private String className;
        private String snakeClassName;
        private String nameInTable;

        public ClassOnlyInfo(Class clazz) {
            this.clazz = clazz;
            this.doExtractClass(clazz);
        }

        private void doExtractClass(Class<?> clazz) {
            this.className = clazz.getSimpleName();
            this.snakeClassName = Utils.camelToSnake(this.className);
            Table tableAnnotation = clazz.getAnnotation(Table.class);
            if (tableAnnotation != null) {
                this.nameInTable = tableAnnotation.name();
            }
        }

        public Class getClazz() {
            return this.clazz;
        }

        public String getClassName() {
            return this.className;
        }

        public String getSnakeClassName() {
            return this.snakeClassName;
        }

        public String getNameInTable() {
            return this.nameInTable;
        }
    }
}

