/*
 * Decompiled with CFR 0.152.
 */
package com.mario6.common.db.mapper;

import com.mario6.common.db.mapper.ClassInfo;
import com.mario6.common.db.mapper.RowMapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class BeanRowMapper<T>
implements RowMapper<T> {
    private boolean snake;
    private Class<T> beanClazz;

    private BeanRowMapper(Class<T> beanClazz, boolean snake) {
        this.beanClazz = beanClazz;
        this.snake = snake;
    }

    public static <T> BeanRowMapper<T> newInstance(Class<T> clazz, boolean snake) {
        return new BeanRowMapper<T>(clazz, snake);
    }

    public static <T> BeanRowMapper<T> newInstantce(Class<T> clazz) {
        return new BeanRowMapper<T>(clazz, false);
    }

    @Override
    public T rowMap(ResultSet rs) throws SQLException {
        ClassInfo classInfo = ClassInfo.newInstance(this.beanClazz, false);
        List<ClassInfo.FieldInfo> fields = classInfo.getFieldsInfo();
        Object obj = classInfo.createByDefaultConstructor();
        for (ClassInfo.FieldInfo field : fields) {
            String column = field.getName(this.snake);
            Class type = this.convertType(field.getType());
            Object value = rs.getObject(column, type);
            field.setValue(obj, value);
        }
        return obj;
    }

    private Class convertType(Class orig) {
        Class<Timestamp> type = orig;
        if (type == Date.class) {
            type = Timestamp.class;
        }
        return type;
    }
}

