/*
 * Decompiled with CFR 0.152.
 */
package com.mario6.common.db.datasource;

import com.mario6.common.db.DataAccessException;
import com.mario6.common.db.datasource.AbstractDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class JdbcDataSource
extends AbstractDataSource {
    private String url;
    private String username;
    private String password;

    private JdbcDataSource(String url) {
        this.url = url;
    }

    private JdbcDataSource(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.username == null || "".equals(this.username)) {
            return DriverManager.getConnection(this.url);
        }
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    public static JdbcDataSource createInstance(Properties config) {
        try {
            return JdbcDataSourceFactory.createDateSource(config);
        }
        catch (Exception e) {
            throw new DataAccessException("\u521b\u5efa\u6570\u636e\u6e90\u5f02\u5e38", e);
        }
    }

    private static class JdbcDataSourceFactory {
        private JdbcDataSourceFactory() {
        }

        public static JdbcDataSource createDateSource(Properties config) throws Exception {
            String driver = config.getProperty("jdbc.driver");
            String url = config.getProperty("jdbc.url");
            String username = config.getProperty("jdbc.username");
            String password = config.getProperty("jdbc.password");
            Class.forName(driver);
            return new JdbcDataSource(url, username, password);
        }
    }
}

