/*
 * Decompiled with CFR 0.152.
 */
package com.mario6.common.db;

import com.mario6.common.db.AutoKey;
import com.mario6.common.db.DataAccessException;
import com.mario6.common.db.DataSourceManager;
import com.mario6.common.db.mapper.MapRowMapper;
import com.mario6.common.db.mapper.RowMapper;
import com.mario6.common.db.mapper.SingleColumnRowMapper;
import com.mario6.common.db.util.JdbcUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class JdbcTemplate {
    private DataSource dataSource;
    private static ThreadLocal<Boolean> AUTO_CLOSE = new ThreadLocal();

    public JdbcTemplate(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(sql, null, rowMapper);
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Object ... params) throws DataAccessException {
        List<Object> paramsToUse = Arrays.asList(params);
        return this.query(sql, paramsToUse, rowMapper);
    }

    public <T> List<T> query(String sql, List params, RowMapper<T> rowMapper) throws DataAccessException {
        Connection conn = this.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        List<Object> result = new ArrayList();
        try {
            stat = conn.prepareStatement(sql);
            this.setPreparedStatement(stat, params);
            rs = stat.executeQuery();
            result = this.resultToList(rs, rowMapper);
            this.closeResultSet(rs);
            this.closeStatement(stat);
            this.tryToCloseConnection();
        }
        catch (SQLException e) {
            try {
                this.closeConnection();
                conn = null;
                throw new DataAccessException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(stat);
                this.tryToCloseConnection();
                throw throwable;
            }
        }
        return result;
    }

    public List<Map<String, Object>> query(String sql, List params) throws DataAccessException {
        return this.query(sql, params, MapRowMapper.newInstance());
    }

    public List<Map<String, Object>> query(String sql) throws DataAccessException {
        return this.query(sql, new ArrayList(0));
    }

    public List<Map<String, Object>> query(String sql, Object ... params) throws DataAccessException {
        List<Object> paramsToUse = Arrays.asList(params);
        return this.query(sql, paramsToUse);
    }

    public <T> T queryForObject(String sql, List params, RowMapper<T> rowMapper) throws DataAccessException {
        Connection conn = this.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        T result = null;
        try {
            stat = conn.prepareStatement(sql);
            this.setPreparedStatement(stat, params);
            rs = stat.executeQuery();
            if (rs.next()) {
                result = rowMapper.rowMap(rs);
            }
            if (rs.next()) {
                throw new DataAccessException("\u7ed3\u679c\u96c6\u6570\u636e\u4e0d\u6b62\u4e00\u884c");
            }
            this.closeResultSet(rs);
            this.closeStatement(stat);
            this.tryToCloseConnection();
        }
        catch (SQLException e) {
            try {
                this.closeConnection();
                conn = null;
                throw new DataAccessException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(stat);
                this.tryToCloseConnection();
                throw throwable;
            }
        }
        return result;
    }

    public <T> T queryForObject(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        return this.queryForObject(sql, null, rowMapper);
    }

    public <T> T queryForObject(String sql, RowMapper<T> rowMapper, Object ... params) throws DataAccessException {
        return this.queryForObject(sql, Arrays.asList(params), rowMapper);
    }

    public Map<String, Object> queryForObject(String sql) throws DataAccessException {
        return this.queryForObject(sql, new ArrayList(0));
    }

    public Map<String, Object> queryForObject(String sql, Object ... params) throws DataAccessException {
        List<Object> paramsToUse = Arrays.asList(params);
        return this.queryForObject(sql, paramsToUse);
    }

    public Map<String, Object> queryForObject(String sql, List params) throws DataAccessException {
        return this.queryForObject(sql, params, MapRowMapper.newInstance());
    }

    public <T> List<T> queryForList(String sql, Class<T> elementType) throws DataAccessException {
        return this.queryForList(sql, null, elementType);
    }

    public <T> List<T> queryForList(String sql, Class<T> elementType, Object ... params) throws DataAccessException {
        return this.queryForList(sql, Arrays.asList(params), elementType);
    }

    public <T> List<T> queryForList(String sql, List params, Class<T> elementType) throws DataAccessException {
        SingleColumnRowMapper mapper = SingleColumnRowMapper.newInstance(elementType);
        return this.query(sql, params, mapper);
    }

    public <T> T queryForObject(String sql, Class<T> requireType) throws DataAccessException {
        return this.queryForObject(sql, null, requireType);
    }

    public <T> T queryForObject(String sql, Class<T> requireType, Object ... params) throws DataAccessException {
        return this.queryForObject(sql, Arrays.asList(params), requireType);
    }

    public <T> T queryForObject(String sql, List params, Class<T> requireType) throws DataAccessException {
        SingleColumnRowMapper mapper = SingleColumnRowMapper.newInstance(requireType);
        return this.queryForObject(sql, params, mapper);
    }

    public int update(String sql) throws DataAccessException {
        return this.update(sql, new ArrayList(0));
    }

    public int update(String sql, Object ... params) throws DataAccessException {
        List<Object> paramsToUse = Arrays.asList(params);
        return this.update(sql, paramsToUse);
    }

    public int update(String sql, List params) throws DataAccessException {
        return this.update(sql, params, null);
    }

    public int update(String sql, AutoKey key) throws DataAccessException {
        return this.update(sql, new ArrayList(0), key);
    }

    public int update(String sql, AutoKey key, Object ... params) throws DataAccessException {
        return this.update(sql, Arrays.asList(params), key);
    }

    public int update(String sql, List params, AutoKey key) throws DataAccessException {
        Connection conn = this.getConnection();
        PreparedStatement stat = null;
        int rows = 0;
        try {
            stat = key != null ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
            this.setPreparedStatement(stat, params);
            rows = stat.executeUpdate();
            if (key != null && rows > 0) {
                ResultSet keys = stat.getGeneratedKeys();
                this.resolveAutoKey(keys, key);
            }
            this.closeStatement(stat);
            this.tryToCloseConnection();
        }
        catch (SQLException e) {
            try {
                this.closeConnection();
                conn = null;
                throw new DataAccessException(e);
            }
            catch (Throwable throwable) {
                this.closeStatement(stat);
                this.tryToCloseConnection();
                throw throwable;
            }
        }
        return rows;
    }

    public Map<Integer, Object> call(String call, Object[] inArgs, int[] outArgs) throws DataAccessException {
        Connection conn = this.getConnection();
        CallableStatement stat = null;
        ResultSet rs = null;
        try {
            int start;
            stat = conn.prepareCall(call);
            this.setPreparedStatement(stat, Arrays.asList(inArgs));
            int n = start = inArgs == null ? 1 : inArgs.length + 1;
            if (outArgs != null) {
                this.registerOutParameter(stat, start, outArgs);
            }
            stat.execute();
            HashMap<Integer, Object> result = new HashMap<Integer, Object>();
            for (int i = 0; i < outArgs.length; ++i) {
                Object value = stat.getObject(start + i);
                result.put(i + 1, value);
            }
            if (result.size() == 0) {
                Map<Integer, Object> map = null;
                return map;
            }
            HashMap<Integer, Object> hashMap = result;
            return hashMap;
        }
        catch (SQLException e) {
            this.closeConnection();
            conn = null;
            throw new DataAccessException(e);
        }
        finally {
            this.closeResultSet(rs);
            this.closeStatement(stat);
            this.tryToCloseConnection();
        }
    }

    public int count(String sql) throws DataAccessException {
        String countSql = this.queryToCount(sql);
        return this.queryForObject(countSql, Integer.class);
    }

    public int count(String sql, List params) throws DataAccessException {
        String countSql = this.queryToCount(sql);
        return this.queryForObject(countSql, Integer.class, params);
    }

    public int count(String sql, Object ... params) throws DataAccessException {
        String countSql = this.queryToCount(sql);
        return this.queryForObject(countSql, Integer.class, params);
    }

    public long countForLong(String sql, List params) throws DataAccessException {
        String countSql = this.queryToCount(sql);
        return this.queryForObject(countSql, Long.class);
    }

    public long countForLong(String sql, Object ... params) throws DataAccessException {
        String countSql = this.queryToCount(sql);
        return this.queryForObject(countSql, Integer.class, params).intValue();
    }

    public boolean isAutoClose() {
        Boolean autoClose = AUTO_CLOSE.get();
        return autoClose == null ? true : autoClose;
    }

    public void setAutoClose(boolean autoClose) {
        AUTO_CLOSE.set(autoClose);
    }

    private String queryToCount(String sql) {
        String upperSql = sql.toUpperCase();
        int sidx = upperSql.indexOf(" FROM ");
        if (sidx < 0) {
            throw new RuntimeException("\u65e0\u6548\u7684\u7edf\u8ba1SQL:" + sql);
        }
        int eidx = upperSql.indexOf(" LIMIT");
        String snippet = "";
        snippet = eidx != -1 ? sql.substring(sidx, eidx + 1) : sql.substring(sidx);
        return "SELECT count(1) total " + snippet;
    }

    private void resolveAutoKey(ResultSet keys, AutoKey key) throws SQLException {
        if (keys.next()) {
            Object value = null;
            value = key instanceof AutoKey.IntegerAutoKey ? Integer.valueOf(keys.getInt(1)) : (key instanceof AutoKey.LongAutoKey ? keys.getString(1) : (key instanceof AutoKey.StringAutoKey ? Long.valueOf(keys.getLong(1)) : keys.getObject(1)));
            key.set(value);
        }
    }

    private <T> List<T> resultToList(ResultSet rs, RowMapper<T> rowMapper) throws SQLException {
        ArrayList<T> results = new ArrayList<T>();
        while (rs.next()) {
            T one = rowMapper.rowMap(rs);
            results.add(one);
        }
        return results;
    }

    private void setPreparedStatement(PreparedStatement stat, List params) throws SQLException {
        if (params == null || params.size() == 0) {
            return;
        }
        for (int i = 0; i < params.size(); ++i) {
            stat.setObject(i + 1, params.get(i));
        }
    }

    private void registerOutParameter(CallableStatement stat, int start, int[] types) throws SQLException {
        for (int i = 0; i < types.length; ++i) {
            stat.registerOutParameter(start + i, types[i]);
        }
    }

    private Connection getConnection() {
        try {
            return DataSourceManager.getConnection(this.dataSource);
        }
        catch (SQLException e) {
            throw new DataAccessException("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25", e);
        }
    }

    public void closeConnection() {
        Connection conn = DataSourceManager.getCurrentConnection(this.dataSource);
        JdbcUtils.closeConnection(conn);
    }

    private void closeResultSet(ResultSet rs) {
        JdbcUtils.closeResultSet(rs);
    }

    private void closeStatement(PreparedStatement stat) {
        JdbcUtils.closeStatement(stat);
    }

    private boolean tryToCloseConnection() {
        if (!DataSourceManager.isTransactionFlag() && this.isAutoClose()) {
            this.closeConnection();
            return true;
        }
        return false;
    }
}

