/*
 * Decompiled with CFR 0.152.
 */
package com.mario6.common.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class DataSourceManager {
    private static ThreadLocal<Map<DataSource, Connection>> LOCAL_CONNECTION = new ThreadLocal();
    private static ThreadLocal<Boolean> TRANSACTION = new ThreadLocal();

    public static Connection getConnection(DataSource ds) throws SQLException {
        Connection conn;
        Map<DataSource, Connection> dsToConnMap = LOCAL_CONNECTION.get();
        if (dsToConnMap != null && (conn = dsToConnMap.get(ds)) != null && !conn.isClosed()) {
            if (DataSourceManager.isTransactionFlag()) {
                conn.setAutoCommit(false);
            }
            return conn;
        }
        conn = ds.getConnection();
        if (DataSourceManager.isTransactionFlag()) {
            conn.setAutoCommit(false);
        }
        if (dsToConnMap == null) {
            dsToConnMap = new HashMap<DataSource, Connection>();
        }
        dsToConnMap.put(ds, conn);
        LOCAL_CONNECTION.set(dsToConnMap);
        return conn;
    }

    public static Connection getCurrentConnection(DataSource ds) {
        Connection conn;
        Map<DataSource, Connection> dsToConnMap = LOCAL_CONNECTION.get();
        if (dsToConnMap != null && (conn = dsToConnMap.get(ds)) != null) {
            return conn;
        }
        return null;
    }

    public static void begin() {
        try {
            List<Connection> connections = DataSourceManager.getAllValidConnection();
            for (Connection conn : connections) {
                conn.setAutoCommit(false);
            }
            DataSourceManager.onTransactionFlag();
        }
        catch (SQLException e) {
            throw new RuntimeException("\u5f00\u59cb\u4e8b\u7269\u5931\u8d25", e);
        }
    }

    public static void commit() {
        try {
            DataSourceManager.offTransactionFlag();
            List<Connection> connections = DataSourceManager.getAllValidConnection();
            for (Connection conn : connections) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u63d0\u4ea4\u4e8b\u7269\u5931\u8d25", e);
        }
    }

    public static void rollback() {
        try {
            DataSourceManager.offTransactionFlag();
            List<Connection> connections = DataSourceManager.getAllValidConnection();
            for (Connection conn : connections) {
                conn.rollback();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u56de\u6eda\u4e8b\u7269\u5931\u8d25", e);
        }
    }

    private static List<Connection> getAllValidConnection() throws SQLException {
        Map<DataSource, Connection> dsToConMap = LOCAL_CONNECTION.get();
        Collection<Connection> values = dsToConMap.values();
        ArrayList<Connection> results = new ArrayList<Connection>();
        for (Connection conn : values) {
            if (conn == null || conn.isClosed()) continue;
            results.add(conn);
        }
        return results;
    }

    private static void onTransactionFlag() {
        TRANSACTION.set(true);
    }

    private static void offTransactionFlag() {
        TRANSACTION.remove();
    }

    public static boolean isTransactionFlag() {
        Boolean transaction = TRANSACTION.get();
        return transaction == null ? false : transaction;
    }
}

