/*
 * Decompiled with CFR 0.152.
 */
package com.mario6.common.db;

public abstract class AutoKey<T> {
    private T value;

    public T get() {
        return this.value;
    }

    public void set(T instance) {
        this.value = instance;
    }

    public static IntegerAutoKey newInstanceWithInteger() {
        return new IntegerAutoKey();
    }

    public static LongAutoKey newInstanceWithLong() {
        return new LongAutoKey();
    }

    public static StringAutoKey newInstanceWithString() {
        return new StringAutoKey();
    }

    public static AutoKey newInstanceWithType(Class type) {
        if (type == Integer.class || type == Integer.TYPE) {
            return AutoKey.newInstanceWithInteger();
        }
        if (type == Long.class || type == Long.TYPE) {
            return AutoKey.newInstanceWithLong();
        }
        if (type == String.class) {
            return AutoKey.newInstanceWithString();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u975eint\u3001long\u3001String\u7c7b\u578b\u7684\u4e3b\u952e");
    }

    public static final class StringAutoKey
    extends AutoKey<String> {
        private StringAutoKey() {
        }
    }

    public static final class LongAutoKey
    extends AutoKey<Long> {
        private LongAutoKey() {
        }
    }

    public static final class IntegerAutoKey
    extends AutoKey<Integer> {
        private IntegerAutoKey() {
        }
    }
}

