package com.mario6.common.db.util;

import java.util.ArrayList;
import java.util.List;

public class Utils {

    public static void main(String[] args) {
        String progress = camelToSnake("progress");
        System.out.println(progress);
    }

    /**
     * 驼峰命名转蛇形
     * @param camel
     * @return
     */
    public static String camelToSnake(String camel) {
        char[] camelChars = camel.toCharArray();
        StringBuilder snakeSb = new StringBuilder();
        int distance = 'A' - 'a';
        for (int i = 0; i < camelChars.length; i++) {
            char cchar = camelChars[i];
            if(i < camelChars.length -1) {
                // 非最后一个字符 && 当前字符'_' && 下一个字符为大写
                char nextChar = camelChars[i + 1];
                if (cchar == '_' && nextChar >= 'A' && nextChar <= 'Z') {
                    continue;
                }
            }

            char schar;
            if(cchar >= 'A' && cchar <= 'Z') {
                if(i != 0) {
                    // 非首字符插入_
                    snakeSb.append("_");
                }
                schar = (char) (cchar - distance);
            } else {
                schar = cchar;
            }
            snakeSb.append(schar);
        }
        return snakeSb.toString();
    }

    /**
     * 蛇形转驼峰命名
     * @param snake
     * @return
     */
    public static String snakeToCamel(String snake) {
        char[] snakeChars = snake.toCharArray();
        StringBuilder camelSb = new StringBuilder();
        int distance = 'A' - 'a';
        for (int i = 0; i < snakeChars.length; i++) {
            char schar = snakeChars[i];
            char cchar = schar;
            if(i < snakeChars.length -1) {
                // 非最后一个字符 && 当前字符'_' && 下一个字符为大写
                if(schar == '_') {
                    char nextChar = snakeChars[i + 1];
                    if (nextChar == '_') continue;

                    if (nextChar >= 'a' && nextChar <= 'z') {
                        cchar = (char) (nextChar + distance);
                        i++;
                    }
                }
            }
            camelSb.append(cchar);
        }
        return camelSb.toString();
    }

    /**
     * 连接成字符串
     * @param separator 分隔符
     * @param members 被连接的序列元素
     * @return
     */
    public static String join(String separator, List<? extends CharSequence> members) {
        return join(separator, null, null, members);
    }

    /**
     * 字符连接
     * @param separator 分割符
     * @param delimiter 包裹元素的界定符
     * @param members
     * @return
     */
    public static String join(String separator,  String delimiter,
                              List<? extends CharSequence> members) {
        return join(separator, delimiter, members);
    }

    /**
     * 字符串连接
     * @param separator 分隔符
     * @param startDelimiter 元素的开始定界符号
     * @param endDelimiter
     * @param members
     * @return
     */
    public static String join(String separator, String startDelimiter, String endDelimiter,
                              List<? extends CharSequence> members) {
        if(members.size() == 0) {
            return "";
        }
        final String startDelimiterToUse = startDelimiter==null?"":startDelimiter;
        final String endDelimiterToUse = endDelimiter==null?"":endDelimiter;
        StringBuilder sb = new StringBuilder();
        for(int i = 0; i < members.size()-1; i++) {
            sb.append(startDelimiterToUse).append(members.get(i)).append(endDelimiterToUse).append(separator);
        }
        sb.append(startDelimiterToUse).append(members.get(members.size()-1)).append(endDelimiterToUse);
        return sb.toString();
    }

    /**
     * 填充集合并返回
     * @param templates
     * @param member
     * @param <T>
     * @return
     */
    public static <T> List<T> fill(List<?> templates, T member) {
        int size = templates.size();
        List<T> results = new ArrayList<>(size);
        for(int i = 0; i < size; i++) {
            results.add(member);
        }
        return results;
    }


}
