package com.mario6.common.db.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * Jdbc工具类
 * 主要提供关闭相关资源
 */
public class JdbcUtils {

    /**
     * 关闭数据库连接
     * @param conn
     */
    public static void closeConnection(Connection conn) {
            try {
                if(conn != null && !conn.isClosed()) {
                    conn.close();
                }
            } catch (SQLException e) {
                // 忽略关闭错误
            }
    }

    /**
     * 关闭结果集
     * @param rs
     */
    public static void closeResultSet(ResultSet rs) {
        try {
            if(rs != null && !rs.isClosed()) {
                rs.close();
            }
        } catch (SQLException e) {
            // 忽略关闭错误
        }
    }

    /**
     * 关闭Statement语句
     * @param statement
     */
    public static void closeStatement(Statement statement) {
        try {
            if (statement != null && !statement.isClosed()) {
                statement.close();
            }
        } catch (SQLException e) {
            // 忽略关闭错误
        }
    }

}
