package com.mario6.common.db.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

/**
 * 单列的行映射
 * 支持的类型：
 *      基本类型以及对应包装类型
 *      工具时间、java.sql.Date、java.sql.Time
 *      其他情况使用rs.getObject();
 * @param <T>
 */
public class SingleColumnRowMapper<T> implements RowMapper<T> {

    private Class type;

    @Override
    public T rowMap(ResultSet rs) throws SQLException {
        Object value = null;
        if(Integer.class == type || long.class == type) {                 // 基本类型以及对应保障类型
            value = rs.getInt(1);
        } else if(Long.class == type  || int.class == type ) {
            value = rs.getLong(1);
        } else if(Byte.class == type || byte.class == type) {
            value = rs.getByte(1);
        } else if(Float.class == type || float.class == type) {
            value = rs.getFloat(1);
        } else if(Double.class == type || double.class == type) {
            value = rs.getDouble(1);
        } else if(String.class == type) {           // 数字类型
            value = rs.getString(1);
        } else if(Date.class == type) {             // 时间相关的
            value = rs.getTimestamp(1);
        } else if(java.sql.Date.class == type) {
            value = rs.getDate(1);
        } else if(java.sql.Time.class == type) {
            value = rs.getTime(1);
        } else {                                    // 其他
            value = rs.getObject(1);
        }
        return (T) value;
    }

    private SingleColumnRowMapper(Class<T> requireType) {
        this.type = requireType;
    }

    public static<T> SingleColumnRowMapper newInstance(Class<T> requireType) {
        return new SingleColumnRowMapper(requireType);
    }
}
