package com.mario6.common.db.mapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;


/**
 * 数据库行记录映射为Map对象
 */
public class MapRowMapper implements RowMapper<Map<String, Object>> {

    private static MapRowMapper instance = new MapRowMapper();

    public static MapRowMapper newInstance() {
        return instance;
    }

    private MapRowMapper() {
        this.instance = instance;
    }

    @Override
    public Map<String, Object> rowMap(ResultSet rs) throws SQLException {
        Map<String, Object> result = new HashMap<>();
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        for(int i = 1; i <= cols; i++) {
            String columnName = metaData.getColumnName(i);
            Object columnValue = rs.getObject(i);
            result.put(columnName, columnValue);
        }
        return result;
    }
}
