package com.mario6.common.db;

/**
 * 对数据库自增主键数据的抽象
 *
 * @param <T> 对应类型
 * @see IntegerAutoKey
 * @see LongAutoKey
 * @see StringAutoKey
 */
public abstract class AutoKey<T> {

    private T value;

    public T get() {
        return value;
    }

    public void set(T instance) {
        this.value = instance;
    }

    /**
     * 返回一个代表整型的自增值的对象
     * @return
     */
    public static IntegerAutoKey newInstanceWithInteger() {
        return new IntegerAutoKey();
    }

    /**
     * 返回一个代表Long的自增值的对象
     * @return
     */
    public static LongAutoKey newInstanceWithLong() {
        return  new LongAutoKey();
    }

    /**
     * 返回一个代表String的自增值的对象
     * @return
     */
    public static StringAutoKey newInstanceWithString() {
        return new StringAutoKey();
    }

    public static AutoKey newInstanceWithType(Class type) {
        if(type == Integer.class || type == int.class) {
            return newInstanceWithInteger();
        } else if(type == Long.class || type == long.class) {
            return newInstanceWithLong();
        } else if(type == String.class) {
            return newInstanceWithString();
        }
        throw new IllegalArgumentException("不支持非int、long、String类型的主键");
    }

    //------------------------------------------------------------------
    // 具体的实例化子类
    //------------------------------------------------------------------
    /**
     * 自增数据类型为Integer的数据模型
     */
    public static final class IntegerAutoKey extends AutoKey<Integer> {
        private IntegerAutoKey() {}
    }

    /**
     * 数据库自动生成的主键为Long的数据类型
     */
    public static final class LongAutoKey extends AutoKey<Long> {

        private LongAutoKey() {}
    }

    /**
     * 数据库自动生成的主键为String类型
     */
    public static final class StringAutoKey extends AutoKey<String> {

        private StringAutoKey() {}
    }
}
