/*
 * Decompiled with CFR 0.152.
 */
package me.lucyy.squirtgun.command.node.subcommand;

import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucyy.squirtgun.command.argument.AbstractArgument;
import me.lucyy.squirtgun.command.context.CommandContext;
import me.lucyy.squirtgun.command.node.CommandNode;
import me.lucyy.squirtgun.command.node.subcommand.SubcommandNode;
import me.lucyy.squirtgun.platform.audience.PermissionHolder;
import org.jetbrains.annotations.Nullable;

public class SubcommandNodeArgument<T extends PermissionHolder>
extends AbstractArgument<CommandNode<T>> {
    private final SubcommandNode<T> parent;

    public SubcommandNodeArgument(SubcommandNode<T> parent, String name, String description) {
        super(name, description, false);
        this.parent = parent;
    }

    private Stream<? extends CommandNode<T>> getValidNodes(String name, PermissionHolder holder) {
        return this.parent.getNodes().stream().filter(node -> node.getName().toLowerCase(Locale.ROOT).startsWith(name.toLowerCase(Locale.ROOT))).filter(node -> node.getPermission() == null || holder.hasPermission(node.getPermission()));
    }

    @Override
    public CommandNode<T> getValue(Queue<String> args, CommandContext<?> context) {
        String raw = args.poll();
        if (raw == null || raw.equals("")) {
            return null;
        }
        return this.getValidNodes(raw, (PermissionHolder)context.getTarget()).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public List<String> tabComplete(Queue<String> args, CommandContext<?> context) {
        String raw = args.poll();
        if (raw == null) {
            return null;
        }
        return this.getValidNodes(raw, (PermissionHolder)context.getTarget()).map(CommandNode::getName).collect(Collectors.toList());
    }

    @Override
    public boolean isOptional() {
        return this.parent.getFallbackNode() == null;
    }
}

