/*
 * Decompiled with CFR 0.152.
 */
package me.lucyy.squirtgun.command.node.subcommand;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.lucyy.squirtgun.command.argument.CommandArgument;
import me.lucyy.squirtgun.command.context.CommandContext;
import me.lucyy.squirtgun.command.node.AbstractNode;
import me.lucyy.squirtgun.command.node.CommandNode;
import me.lucyy.squirtgun.command.node.subcommand.SubcommandHelpNode;
import me.lucyy.squirtgun.command.node.subcommand.SubcommandNodeArgument;
import me.lucyy.squirtgun.platform.audience.PermissionHolder;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubcommandNode<T extends PermissionHolder>
extends AbstractNode<T> {
    private final Set<CommandNode<T>> childNodes;
    private final CommandArgument<CommandNode<T>> argument;
    private CommandNode<T> fallbackNode;

    @SafeVarargs
    public static <T extends PermissionHolder> SubcommandNode<T> withHelp(String name, String description, @Nullable String permission, CommandNode<T> ... childNodes) {
        SubcommandNode<T> node = new SubcommandNode<T>(name, description, permission, childNodes);
        super.setFallbackNode(new SubcommandHelpNode(node));
        return node;
    }

    @SafeVarargs
    public static <T extends PermissionHolder> SubcommandNode<T> withFallback(String name, String description, @Nullable String permission, @NotNull CommandNode<T> fallback, CommandNode<T> ... childNodes) {
        SubcommandNode<T> node = new SubcommandNode<T>(name, description, permission, childNodes);
        super.setFallbackNode(fallback);
        return node;
    }

    @SafeVarargs
    public static <T extends PermissionHolder> SubcommandNode<T> withBasicHelp(String name, String description, @Nullable String permission, CommandNode<T> ... childNodes) {
        return new SubcommandNode<T>(name, description, permission, childNodes);
    }

    @SafeVarargs
    protected SubcommandNode(@NotNull String name, @NotNull String description, @Nullable String permission, CommandNode<T> ... childNodes) {
        super(name, description, permission);
        Preconditions.checkNotNull(childNodes, (Object)"Child nodes must not be null");
        this.childNodes = new HashSet<CommandNode<T>>(Arrays.asList(childNodes));
        this.argument = new SubcommandNodeArgument(this, "subcommand", "The subcommand to execute");
    }

    public Set<? extends CommandNode<T>> getNodes() {
        return this.childNodes;
    }

    private void setFallbackNode(CommandNode<T> fallback) {
        this.fallbackNode = fallback;
        this.childNodes.add(fallback);
    }

    @Nullable
    public CommandNode<T> getFallbackNode() {
        return this.fallbackNode;
    }

    @Override
    @NotNull
    public List<CommandArgument<?>> getArguments() {
        return ImmutableList.of(this.argument);
    }

    @Override
    @Nullable
    public CommandNode<T> next(CommandContext<T> context) {
        CommandNode<T> name = context.getArgumentValue(this.argument);
        return name == null ? this.fallbackNode : name;
    }

    @Override
    @Nullable
    public Component execute(CommandContext<T> context) {
        return null;
    }
}

