/*
 * Decompiled with CFR 0.152.
 */
package me.lucyy.squirtgun.command.node.subcommand;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.lucyy.squirtgun.command.argument.CommandArgument;
import me.lucyy.squirtgun.command.argument.ListArgument;
import me.lucyy.squirtgun.command.context.CommandContext;
import me.lucyy.squirtgun.command.node.CommandNode;
import me.lucyy.squirtgun.command.node.HelpNode;
import me.lucyy.squirtgun.command.node.subcommand.SubcommandNode;
import me.lucyy.squirtgun.format.FormatProvider;
import me.lucyy.squirtgun.format.TextFormatter;
import me.lucyy.squirtgun.platform.audience.PermissionHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubcommandHelpNode<T extends PermissionHolder>
implements CommandNode<T> {
    private final SubcommandNode<?> parentNode;
    private final CommandArgument<String> childArgument;

    public SubcommandHelpNode(SubcommandNode<?> parentNode) {
        this.parentNode = parentNode;
        this.childArgument = new ListArgument("command", "The command to get help for.", true, parentNode.getNodes().stream().map(CommandNode::getName).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public List<CommandArgument<?>> getArguments() {
        return ImmutableList.of(this.childArgument);
    }

    @Override
    @NotNull
    public String getName() {
        return "help";
    }

    @Override
    public String getDescription() {
        return "Shows this screen.";
    }

    @Override
    @Nullable
    public CommandNode<T> next(CommandContext<T> context) {
        String child = context.getArgumentValue(this.childArgument);
        if (child == null) {
            return null;
        }
        Optional<CommandNode> nodeWithGivenName = this.parentNode.getNodes().stream().filter(node -> node.getName().equals(child)).findFirst();
        return nodeWithGivenName.map(HelpNode::new).orElse(null);
    }

    @Override
    @Nullable
    public Component execute(CommandContext<T> context) {
        FormatProvider fmt = context.getFormat();
        Component out = ((TextComponent)Component.empty().append(TextFormatter.formatTitle((String)"Commands:", (FormatProvider)fmt))).append((Component)Component.newline());
        for (CommandNode<?> node : this.parentNode.getNodes()) {
            String perm = node.getPermission();
            if (perm != null && !context.getTarget().hasPermission(perm)) continue;
            Component innerComp = fmt.formatMain(this.parentNode.getName() + " ").append(fmt.formatAccent(node.getName())).append(fmt.formatMain(" - " + node.getDescription())).append((Component)Component.text((String)"\n"));
            out = out.append(innerComp);
        }
        out = out.append((Component)Component.newline()).append(TextFormatter.formatTitle((String)"*", (FormatProvider)fmt));
        return out;
    }
}

