/*
 * Decompiled with CFR 0.152.
 */
package me.lucyy.squirtgun.command.node;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import me.lucyy.squirtgun.command.argument.CommandArgument;
import me.lucyy.squirtgun.command.context.CommandContext;
import me.lucyy.squirtgun.command.node.CommandNode;
import me.lucyy.squirtgun.platform.audience.PermissionHolder;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeBuilder<T extends PermissionHolder> {
    private String name;
    private String description;
    private String permission;
    private Function<CommandContext<T>, @Nullable Component> executes;
    private CommandNode<T> next;
    private final List<CommandArgument<?>> arguments = new ArrayList();

    public NodeBuilder<T> name(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name must not be null");
        this.name = name;
        return this;
    }

    public NodeBuilder<T> description(@NotNull String description) {
        this.description = description;
        return this;
    }

    public NodeBuilder<T> permission(@Nullable String permission) {
        this.permission = permission;
        return this;
    }

    public NodeBuilder<T> executes(@NotNull Function<CommandContext<T>, @Nullable Component> executes) {
        Preconditions.checkNotNull(executes, (Object)"Executes function must not be null");
        this.executes = executes;
        return this;
    }

    public NodeBuilder<T> next(@Nullable CommandNode<T> next) {
        this.next = next;
        return this;
    }

    public NodeBuilder<T> arguments(CommandArgument<?> ... arguments) {
        this.arguments.addAll(Arrays.asList(arguments));
        return this;
    }

    public CommandNode<T> build() {
        return new BuiltCommandNode(this.name, this.description, this.permission, this.executes, this.next, this.arguments);
    }

    private static class BuiltCommandNode<T extends PermissionHolder>
    implements CommandNode<T> {
        private final String name;
        private final String description;
        @Nullable
        private final String permission;
        private final Function<CommandContext<T>, @Nullable Component> executes;
        @Nullable
        private final CommandNode<T> next;
        private final List<CommandArgument<?>> arguments;

        private BuiltCommandNode(String name, String description, @Nullable String permission, Function<CommandContext<T>, @Nullable Component> executes, @Nullable CommandNode<T> next, List<CommandArgument<?>> arguments) {
            this.name = name;
            this.description = description;
            this.permission = permission;
            this.executes = executes;
            this.next = next;
            this.arguments = arguments;
        }

        @Override
        @Nullable
        public Component execute(CommandContext<T> context) {
            return this.executes.apply(context);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        @Nullable
        public String getPermission() {
            return this.permission;
        }

        @Override
        @NotNull
        public List<CommandArgument<?>> getArguments() {
            return this.arguments;
        }

        @Override
        @Nullable
        public CommandNode<T> next(CommandContext<T> context) {
            return this.next;
        }
    }
}

