/*
 * Decompiled with CFR 0.152.
 */
package me.lucyy.squirtgun.command.argument;

import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import me.lucyy.squirtgun.command.argument.AbstractArgument;
import me.lucyy.squirtgun.command.context.CommandContext;
import me.lucyy.squirtgun.platform.Platform;
import me.lucyy.squirtgun.platform.audience.SquirtgunPlayer;
import org.jetbrains.annotations.Nullable;

public class OnlinePlayerArgument
extends AbstractArgument<SquirtgunPlayer> {
    private final Platform platform;

    public OnlinePlayerArgument(String name, String description, boolean isOptional, Platform platform) {
        super(name, description, isOptional);
        this.platform = platform;
    }

    @Override
    public SquirtgunPlayer getValue(Queue<String> args, CommandContext<?> ctx) {
        String name = args.poll();
        return name == null || "".equals(name) ? null : this.platform.getPlayer(name);
    }

    @Override
    @Nullable
    public List<String> tabComplete(Queue<String> args, CommandContext<?> ctx) {
        String name = args.poll();
        return name == null ? null : this.platform.getOnlinePlayers().stream().map(SquirtgunPlayer::getUsername).filter(username -> username.startsWith(name)).collect(Collectors.toList());
    }
}

