/*
 * Decompiled with CFR 0.152.
 */
package me.lucyy.squirtgun.command.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;
import me.lucyy.squirtgun.command.argument.CommandArgument;
import me.lucyy.squirtgun.command.context.CommandContext;
import me.lucyy.squirtgun.command.node.CommandNode;
import me.lucyy.squirtgun.format.FormatProvider;
import me.lucyy.squirtgun.platform.PermissionHolder;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringContext<T extends PermissionHolder>
implements CommandContext<T> {
    private final FormatProvider provider;
    private final T target;
    private final CommandNode<T> node;
    private final String raw;
    private final LinkedHashMap<CommandArgument<?>, Object> argValues = new LinkedHashMap();
    private CommandNode<T> tail;

    private void populateArguments(CommandNode<T> node, Queue<String> raw, boolean findValues) {
        this.tail = node;
        for (CommandArgument<?> arg : node.getArguments()) {
            this.argValues.put(arg, findValues ? (Object)arg.getValue(raw) : null);
        }
        CommandNode<T> next = node.next(this);
        if (next == null) {
            return;
        }
        String perm = next.getPermission();
        if (perm != null && !this.getTarget().hasPermission(perm)) {
            return;
        }
        this.populateArguments(next, raw, findValues);
    }

    private Queue<String> getArgsAsList(String value) {
        return new LinkedList<String>(Arrays.asList(value.split(" ", -1)));
    }

    public StringContext(FormatProvider provider, T target, CommandNode<T> node, String value) {
        this.node = node;
        this.raw = value;
        this.provider = provider;
        this.target = target;
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    @Override
    @Nullable
    public <U> U getArgumentValue(CommandArgument<U> name) {
        return (U)this.argValues.get(name);
    }

    @Override
    @Nullable
    public Object getArgumentValue(String name) {
        Optional<CommandArgument> argument = this.argValues.keySet().stream().filter(arg -> arg.getName().equals(name)).findFirst();
        if (!argument.isPresent()) {
            throw new IllegalArgumentException(String.format("Argument %s does not exist", name));
        }
        return this.getArgumentValue(argument.get());
    }

    @Override
    public String getRaw() {
        return this.raw;
    }

    @Override
    @NotNull
    public FormatProvider getFormat() {
        return this.provider;
    }

    @Override
    public List<String> tabComplete() {
        Queue<String> rawQueue = this.getArgsAsList(this.raw);
        this.populateArguments(this.node, this.getArgsAsList(this.raw), true);
        ArrayList<List<String>> results = new ArrayList<List<String>>();
        ArrayList argTree = new ArrayList(this.argValues.keySet());
        int argIdx = 0;
        while (!rawQueue.isEmpty()) {
            if (argIdx >= argTree.size()) {
                return null;
            }
            CommandArgument arg = (CommandArgument)argTree.get(argIdx);
            results.add(arg.tabComplete(rawQueue));
            ++argIdx;
        }
        return (List)results.get(results.size() - 1);
    }

    @Override
    public Component execute() {
        this.populateArguments(this.node, this.getArgsAsList(this.raw), true);
        String perm = this.getTail().getPermission();
        if (perm != null && !this.getTarget().hasPermission(perm)) {
            return Component.text((String)"No permission!");
        }
        for (CommandArgument<?> argument : this.getTail().getArguments()) {
            if (argument.isOptional() || this.getArgumentValue(argument) != null) continue;
            return this.getFormat().getPrefix().append(this.getFormat().formatMain("Usage: " + this.getTail().getName() + " " + this.getTail().getArguments().stream().map(Object::toString).collect(Collectors.joining(" "))));
        }
        return this.getTail().execute(this);
    }

    @Override
    public CommandNode<T> getTail() {
        return this.tail;
    }
}

