/*
 * Decompiled with CFR 0.152.
 */
package me.lucyy.squirtgun.command.argument;

import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import me.lucyy.squirtgun.command.argument.AbstractArgument;
import org.jetbrains.annotations.Nullable;

public class ListArgument
extends AbstractArgument<String> {
    private final List<String> values;

    public ListArgument(String name, String description, boolean isOptional, List<String> values) {
        super(name, description, isOptional);
        this.values = values;
    }

    @Override
    public String getValue(Queue<String> args) {
        String val = args.poll();
        return val != null && this.values.contains(val) ? val : null;
    }

    @Override
    @Nullable
    public List<String> tabComplete(Queue<String> value) {
        String top = value.poll();
        if (top == null) {
            return null;
        }
        return this.values.stream().filter(x -> x.startsWith(top)).collect(Collectors.toList());
    }
}

