/*
 * Decompiled with CFR 0.152.
 */
package me.lucyy.squirtgun.command.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.lucyy.squirtgun.command.argument.CommandArgument;
import me.lucyy.squirtgun.command.argument.ListArgument;
import me.lucyy.squirtgun.command.context.CommandContext;
import me.lucyy.squirtgun.command.node.CommandNode;
import me.lucyy.squirtgun.command.node.SubcommandHelpNode;
import me.lucyy.squirtgun.platform.PermissionHolder;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubcommandNode<T extends PermissionHolder>
implements CommandNode<T> {
    private final Set<? extends CommandNode<T>> childNodes;
    private final String name;
    @Nullable
    private final String permission;
    private final CommandArgument<String> argument;
    private final CommandNode<T> helpNode;

    @SafeVarargs
    public SubcommandNode(@NotNull String name, @Nullable String permission, boolean addHelpNode, CommandNode<T> ... childNodes) {
        Preconditions.checkNotNull(childNodes, (Object)"Child nodes must not be null");
        Preconditions.checkNotNull((Object)name, (Object)"Name must not be null");
        HashSet<CommandNode<T>> nodes = new HashSet<CommandNode<T>>(Arrays.asList(childNodes));
        this.childNodes = nodes;
        this.name = name;
        this.permission = permission;
        if (addHelpNode) {
            this.helpNode = new SubcommandHelpNode(this);
            nodes.add(this.helpNode);
        } else {
            this.helpNode = null;
        }
        this.argument = new ListArgument("subcommand", "The subcommand to execute", addHelpNode, this.childNodes.stream().map(CommandNode::getName).collect(Collectors.toList()));
    }

    @Nullable
    private CommandNode<T> getNode(String name) {
        return this.childNodes.stream().filter(x -> x.getName().equals(name)).findFirst().orElse(null);
    }

    @Override
    @NotNull
    public List<CommandArgument<?>> getArguments() {
        return ImmutableList.of(this.argument);
    }

    public Set<? extends CommandNode<T>> getNodes() {
        return this.childNodes;
    }

    @Override
    @Nullable
    public CommandNode<T> next(CommandContext<T> context) {
        String name = context.getArgumentValue(this.argument);
        return name == null ? this.helpNode : this.getNode(name);
    }

    @Override
    @Nullable
    public Component execute(CommandContext<T> context) {
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    @Nullable
    public String getPermission() {
        return this.permission;
    }
}

