/*
 * Decompiled with CFR 0.152.
 */
package me.lucyy.squirtgun.command.node;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.lucyy.squirtgun.command.argument.CommandArgument;
import me.lucyy.squirtgun.command.context.CommandContext;
import me.lucyy.squirtgun.command.node.CommandNode;
import me.lucyy.squirtgun.format.FormatProvider;
import me.lucyy.squirtgun.format.TextFormatter;
import me.lucyy.squirtgun.platform.PermissionHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HelpNode<T extends PermissionHolder>
implements CommandNode<T> {
    private final CommandNode<?> parentNode;

    public HelpNode(CommandNode<?> parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    @Nullable
    public Component execute(CommandContext<T> context) {
        FormatProvider format = context.getFormat();
        Component out = ((TextComponent)Component.empty().append(TextFormatter.formatTitle((String)"Command Help", (FormatProvider)format))).append((Component)Component.newline());
        String fullCommand = this.parentNode.getName() + " " + this.parentNode.getArguments().stream().map(Object::toString).collect(Collectors.joining());
        out = out.append(TextFormatter.centreText((String)this.parentNode.getDescription(), (FormatProvider)format, (String)" ")).append((Component)Component.newline()).append(format.formatAccent("Usage")).append(format.formatMain(": " + fullCommand)).append((Component)Component.newline());
        if (this.parentNode.getArguments().size() != 0) {
            out = out.append((Component)Component.newline()).append(TextFormatter.centreText((String)"Arguments", (FormatProvider)format, (String)" ")).append((Component)Component.newline());
            for (CommandArgument<?> argument : this.parentNode.getArguments()) {
                out = out.append(format.formatAccent(argument.getName())).append(format.formatMain(" - " + argument.getDescription())).append((Component)Component.newline());
            }
        }
        out = out.append((Component)Component.newline()).append(TextFormatter.formatTitle((String)"*", (FormatProvider)context.getFormat()));
        return out;
    }

    @Override
    @NotNull
    public String getName() {
        return "help";
    }

    @Override
    public String getDescription() {
        return "Shows help on using this command.";
    }

    @Override
    @NotNull
    public List<CommandArgument<?>> getArguments() {
        return Collections.emptyList();
    }
}

