/*
 * Decompiled with CFR 0.152.
 */
package me.lucyy.squirtgun.bukkit.task;

import java.util.HashMap;
import java.util.Map;
import me.lucyy.squirtgun.bukkit.BukkitPlatform;
import me.lucyy.squirtgun.platform.Platform;
import me.lucyy.squirtgun.platform.scheduler.Task;
import me.lucyy.squirtgun.platform.scheduler.TaskScheduler;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.Nullable;

public class BukkitTaskScheduler
implements TaskScheduler {
    private final Map<Task, BukkitTask> taskMap = new HashMap<Task, BukkitTask>();
    private final BukkitPlatform platform;

    public BukkitTaskScheduler(BukkitPlatform platform) {
        this.platform = platform;
    }

    BukkitTask register(Task task) {
        BukkitScheduler sched = Bukkit.getScheduler();
        if (task.isAsync()) {
            if (task.isRepeating()) {
                return sched.runTaskTimerAsynchronously((Plugin)this.platform.getBukkitPlugin(), () -> task.execute((Platform)this.platform), (long)task.getDelay(), (long)task.getInterval());
            }
            return sched.runTaskLaterAsynchronously((Plugin)this.platform.getBukkitPlugin(), () -> task.execute((Platform)this.platform), (long)task.getDelay());
        }
        if (task.isRepeating()) {
            return sched.runTaskTimer((Plugin)this.platform.getBukkitPlugin(), () -> task.execute((Platform)this.platform), (long)task.getDelay(), (long)task.getInterval());
        }
        return sched.runTaskLater((Plugin)this.platform.getBukkitPlugin(), () -> task.execute((Platform)this.platform), (long)task.getDelay());
    }

    public void start(Task task) {
        BukkitTask bukkitTask = this.register(task);
        this.taskMap.put(task, bukkitTask);
    }

    public void cancel(Task task) {
        @Nullable BukkitTask bukkitTask = this.taskMap.get(task);
        if (bukkitTask == null) {
            return;
        }
        bukkitTask.cancel();
        this.taskMap.remove(task);
    }
}

