/*
 * Decompiled with CFR 0.152.
 */
package me.lucyy.squirtgun.bukkit;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.lucyy.squirtgun.platform.Gamemode;
import me.lucyy.squirtgun.platform.SquirtgunPlayer;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class BukkitPlayer
implements SquirtgunPlayer {
    private final OfflinePlayer parent;
    private static final EnumMap<GameMode, Gamemode> gamemodeMap = new EnumMap(GameMode.class);

    public BukkitPlayer(OfflinePlayer parent) {
        this.parent = parent;
    }

    public UUID getUuid() {
        return this.parent.getUniqueId();
    }

    public String getUsername() {
        return this.parent.getName();
    }

    public boolean isOnline() {
        return this.parent.isOnline();
    }

    public boolean hasPermission(String permission) {
        if (this.parent instanceof Player) {
            return ((Player)this.parent).hasPermission(permission);
        }
        return false;
    }

    public Gamemode getGamemode() {
        if (this.parent instanceof Player) {
            return gamemodeMap.get(((Player)this.parent).getGameMode());
        }
        return null;
    }

    public void setGamemode(Gamemode mode) {
        if (this.parent instanceof Player) {
            GameMode bukkitMode = gamemodeMap.entrySet().stream().filter(k -> k.getValue() == mode).map(Map.Entry::getKey).findFirst().orElse(null);
            Objects.requireNonNull(bukkitMode);
            ((Player)this.parent).setGameMode(bukkitMode);
        }
    }

    static {
        gamemodeMap.put(GameMode.CREATIVE, Gamemode.CREATIVE);
        gamemodeMap.put(GameMode.SURVIVAL, Gamemode.SURVIVAL);
        gamemodeMap.put(GameMode.ADVENTURE, Gamemode.ADVENTURE);
        gamemodeMap.put(GameMode.SPECTATOR, Gamemode.SPECTATOR);
    }
}

