/*
 * Decompiled with CFR 0.152.
 */
package me.lucyy.squirtgun.bukkit;

import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import me.lucyy.squirtgun.bukkit.BukkitListenerAdapter;
import me.lucyy.squirtgun.bukkit.BukkitPlayer;
import me.lucyy.squirtgun.bukkit.task.BukkitTaskScheduler;
import me.lucyy.squirtgun.platform.AuthMode;
import me.lucyy.squirtgun.platform.EventListener;
import me.lucyy.squirtgun.platform.Platform;
import me.lucyy.squirtgun.platform.SquirtgunPlayer;
import me.lucyy.squirtgun.platform.scheduler.TaskScheduler;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitPlatform
implements Platform {
    private final JavaPlugin plugin;
    private final BukkitTaskScheduler scheduler = new BukkitTaskScheduler(this);
    private final BukkitListenerAdapter listenerAdapter = new BukkitListenerAdapter();

    public BukkitPlatform(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this.listenerAdapter, (Plugin)plugin);
    }

    public JavaPlugin getBukkitPlugin() {
        return this.plugin;
    }

    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    public String getPluginName() {
        return this.plugin.getName();
    }

    public String getPluginVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String[] getAuthors() {
        return this.plugin.getDescription().getAuthors().toArray(new String[0]);
    }

    public AuthMode getAuthMode() {
        boolean onlineMode = Bukkit.getOnlineMode();
        try {
            if (Class.forName("org.spigotmc.SpigotConfig").getField("bungee").getBoolean(null)) {
                return AuthMode.BUNGEE;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return onlineMode ? AuthMode.ONLINE : AuthMode.OFFLINE;
    }

    public TaskScheduler getTaskScheduler() {
        return this.scheduler;
    }

    public void registerEventListener(EventListener listener) {
        this.listenerAdapter.addListener(listener);
    }

    public void unregisterEventListener(EventListener listener) {
        this.listenerAdapter.removeListener(listener);
    }

    public SquirtgunPlayer getPlayer(UUID uuid) {
        return new BukkitPlayer(Bukkit.getOfflinePlayer((UUID)uuid));
    }

    public SquirtgunPlayer getPlayer(String name) {
        return new BukkitPlayer(Bukkit.getOfflinePlayer((String)name));
    }

    public List<SquirtgunPlayer> getOnlinePlayers() {
        return Bukkit.getOnlinePlayers().stream().map(BukkitPlayer::new).collect(Collectors.toList());
    }
}

