/*
 * Decompiled with CFR 0.152.
 */
package me.lucyy.squirtgun.bukkit;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.lucyy.squirtgun.bukkit.BukkitPlayer;
import me.lucyy.squirtgun.bukkit.BukkitSenderWrapper;
import me.lucyy.squirtgun.command.context.StringContext;
import me.lucyy.squirtgun.command.node.CommandNode;
import me.lucyy.squirtgun.format.FormatProvider;
import me.lucyy.squirtgun.platform.PermissionHolder;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitNodeExecutor
implements TabExecutor {
    private final CommandNode<PermissionHolder> node;
    private final FormatProvider formatter;

    public BukkitNodeExecutor(CommandNode<PermissionHolder> node, FormatProvider formatter) {
        this.node = node;
        this.formatter = formatter;
    }

    public boolean onCommand(@NotNull CommandSender bukkitSender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Object sender = bukkitSender instanceof OfflinePlayer ? new BukkitPlayer((OfflinePlayer)bukkitSender) : new BukkitSenderWrapper(bukkitSender);
        Component ret = new StringContext(this.formatter, (PermissionHolder)sender, this.node, String.join((CharSequence)" ", args)).execute();
        if (ret != null) {
            bukkitSender.sendMessage(ret);
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] stringArgs) {
        StringContext context = new StringContext(this.formatter, (PermissionHolder)new BukkitSenderWrapper(sender), this.node, String.join((CharSequence)" ", stringArgs));
        List ret = context.tabComplete();
        return ret == null ? ImmutableList.of() : ret;
    }
}

