/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.scriptcontroller.internal;

import java.io.IOException;
import java.nio.file.Path;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import me.lucko.scriptcontroller.environment.ScriptEnvironment;
import me.lucko.scriptcontroller.environment.loader.EnvironmentScriptLoader;
import me.lucko.scriptcontroller.environment.registry.ScriptRegistry;
import me.lucko.scriptcontroller.exports.ExportRegistry;
import me.lucko.scriptcontroller.internal.Duration;
import me.lucko.scriptcontroller.internal.EnvironmentSettingsImpl;
import me.lucko.scriptcontroller.internal.ScriptControllerImpl;
import me.lucko.scriptcontroller.internal.ScriptLoaderImpl;

class ScriptEnvironmentImpl
implements ScriptEnvironment {
    private final ScriptControllerImpl controller;
    private final EnvironmentSettingsImpl settings;
    private final Path directory;
    private final ScriptRegistry scriptRegistry;
    private final ExportRegistry exportRegistry;
    private final ScriptEngine scriptEngine;
    private final EnvironmentScriptLoader loader;
    private final AutoCloseable loaderPollingTask;

    public ScriptEnvironmentImpl(ScriptControllerImpl controller, Path directory, EnvironmentSettingsImpl settings) {
        this.controller = controller;
        this.directory = directory;
        this.settings = settings;
        this.scriptRegistry = ScriptRegistry.create();
        this.exportRegistry = ExportRegistry.create();
        this.scriptEngine = new ScriptEngineManager(ScriptEnvironmentImpl.class.getClassLoader()).getEngineByName("nashorn");
        try {
            this.loader = new ScriptLoaderImpl(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.loader.watch(settings.getInitScript());
        this.loader.preload();
        Duration rate = settings.getPollRate();
        this.loaderPollingTask = settings.getLoadExecutor().scheduleAtFixedRate(this.loader, rate.getDuration(), rate.getUnit());
    }

    @Override
    public ScriptControllerImpl getController() {
        return this.controller;
    }

    @Override
    public EnvironmentSettingsImpl getSettings() {
        return this.settings;
    }

    @Override
    public Path getDirectory() {
        return this.directory;
    }

    @Override
    public EnvironmentScriptLoader getLoader() {
        return this.loader;
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    @Override
    public ScriptRegistry getScriptRegistry() {
        return this.scriptRegistry;
    }

    @Override
    public ExportRegistry getExportRegistry() {
        return this.exportRegistry;
    }

    @Override
    public void close() throws Exception {
        this.loaderPollingTask.close();
        this.loader.close();
        this.scriptRegistry.close();
    }
}

