/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.scriptcontroller.internal;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import me.lucko.scriptcontroller.closable.CompositeAutoClosable;
import me.lucko.scriptcontroller.environment.loader.EnvironmentScriptLoader;
import me.lucko.scriptcontroller.environment.registry.ScriptRegistry;
import me.lucko.scriptcontroller.environment.script.Script;
import me.lucko.scriptcontroller.internal.ScriptEnvironmentImpl;
import me.lucko.scriptcontroller.internal.ScriptImpl;
import me.lucko.scriptcontroller.logging.SystemLogger;

class ScriptLoaderImpl
implements EnvironmentScriptLoader {
    private static final WatchEvent.Kind<?>[] EVENTS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    private final ScriptEnvironmentImpl environment;
    private final WatchService watchService;
    private WatchKey watchKey;
    private List<Path> files = new ArrayList<Path>();
    private final ReentrantLock lock = new ReentrantLock();

    public ScriptLoaderImpl(ScriptEnvironmentImpl environment) throws IOException {
        this.environment = environment;
        Path directory = environment.getDirectory();
        this.watchService = directory.getFileSystem().newWatchService();
        this.watchKey = directory.register(this.watchService, EVENTS);
    }

    @Override
    public ScriptEnvironmentImpl getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watchAll(Collection<String> paths) {
        this.lock.lock();
        try {
            for (String s : paths) {
                this.files.add(Paths.get(s, new String[0]));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unwatchAll(Collection<String> paths) {
        this.lock.lock();
        try {
            for (String s : paths) {
                this.files.remove(Paths.get(s, new String[0]));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void preload() {
        int filesLength;
        do {
            filesLength = this.files.size();
            this.run();
        } while (filesLength != this.files.size());
    }

    @Override
    public void run() {
        this.lock.lock();
        try {
            this.reload();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void reload() {
        Script script;
        Path directory = this.environment.getDirectory();
        ScriptRegistry registry = this.environment.getScriptRegistry();
        SystemLogger logger = this.environment.getController().getLogger();
        LinkedHashSet<Path> toReload = new LinkedHashSet<Path>();
        LinkedHashSet<Path> toLoad = new LinkedHashSet<Path>();
        LinkedHashSet<Script> toUnload = new LinkedHashSet<Script>();
        for (Path path : this.files) {
            Script script2 = registry.getScript(path);
            if (directory.resolve(path).toFile().exists()) {
                if (script2 != null) continue;
                toLoad.add(path);
                continue;
            }
            if (script2 == null) continue;
            toUnload.add(script2);
        }
        for (Map.Entry entry : registry.getAll().entrySet()) {
            if (this.files.contains(entry.getKey())) continue;
            toUnload.add((Script)entry.getValue());
        }
        HashSet<Path> tryUnload = new HashSet<Path>();
        List<WatchEvent<?>> list = this.watchKey.pollEvents();
        for (WatchEvent watchEvent : list) {
            Path path = (Path)watchEvent.context();
            if (path == null || toLoad.contains(path) || toUnload.stream().anyMatch(s -> s.getPath().equals(context))) continue;
            if (watchEvent.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                tryUnload.add(path);
                continue;
            }
            script = registry.getScript(path);
            if (script == null) {
                if (this.files.contains(path)) {
                    toLoad.add(path);
                    continue;
                }
                toReload.add(path);
                continue;
            }
            toReload.add(script.getPath());
        }
        boolean valid = this.watchKey.reset();
        if (!valid) {
            new RuntimeException("WatchKey no longer valid: " + list.toString()).printStackTrace();
            try {
                this.watchKey = directory.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        for (Path path : tryUnload) {
            script = registry.getScript(path);
            if (script == null || toLoad.contains(path) || toReload.contains(path)) continue;
            toUnload.add(script);
        }
        LinkedHashSet<Path> linkedHashSet = new LinkedHashSet<Path>();
        for (Path p : toReload) {
            this.resolveDepends(linkedHashSet, p);
        }
        HashSet<Script> hashSet = new HashSet<Script>();
        HashSet<ScriptImpl> toRun = new HashSet<ScriptImpl>();
        for (Path path : linkedHashSet) {
            Script oldScript = registry.getScript(path);
            if (oldScript == null) continue;
            hashSet.add(oldScript);
            ScriptImpl newScript = new ScriptImpl(this, path);
            registry.register(newScript);
            toRun.add(newScript);
            logger.info("[LOADER] Reloaded script: " + ScriptLoaderImpl.pathToString(path));
        }
        for (Path path : toLoad) {
            if (registry.getScript(path) != null) continue;
            ScriptImpl script4 = new ScriptImpl(this, path);
            registry.register(script4);
            toRun.add(script4);
            logger.info("[LOADER] Loaded script: " + ScriptLoaderImpl.pathToString(path));
        }
        for (Script s2 : toUnload) {
            registry.unregister(s2);
            hashSet.add(s2);
            logger.info("[LOADER] Unloaded script: " + ScriptLoaderImpl.pathToString(s2.getPath()));
        }
        Executor runExecutor = this.environment.getSettings().getRunExecutor();
        runExecutor.execute(() -> {
            CompositeAutoClosable.create().bindAll(toTerminate).closeAndReportExceptions();
            for (ScriptImpl script : toRun) {
                try {
                    script.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void resolveDepends(Set<Path> accumulator, Path path) {
        if (!accumulator.add(path)) {
            return;
        }
        for (Script other : this.environment.getScriptRegistry().getAll().values()) {
            if (!other.getDependencies().contains(path)) continue;
            this.resolveDepends(accumulator, other.getPath());
        }
    }

    @Override
    public void close() throws IOException {
        this.watchKey.cancel();
        this.watchService.close();
        this.files.clear();
    }

    private static String pathToString(Path path) {
        return path.toString().replace("\\", "/");
    }
}

