/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.scriptcontroller.internal;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import me.lucko.scriptcontroller.bindings.BindingsBuilder;
import me.lucko.scriptcontroller.bindings.BindingsSupplier;
import me.lucko.scriptcontroller.closable.CompositeAutoClosable;
import me.lucko.scriptcontroller.environment.loader.DelegateScriptLoader;
import me.lucko.scriptcontroller.environment.loader.ScriptLoader;
import me.lucko.scriptcontroller.environment.script.Script;
import me.lucko.scriptcontroller.internal.ScriptLoaderImpl;
import me.lucko.scriptcontroller.logging.ScriptLogger;

class ScriptImpl
implements Script,
Runnable {
    private static final String GLOBAL_SCRIPT_HEADER = "load(\"nashorn:mozilla_compat.js\");\r\nvar __load = load;\r\nvar load = function(file) {\r\n    __load(rsd + file);\r\n    depend(file);\r\n};";
    private static final Function<Path, String> LOAD_FUNCTION = path -> "__load(\"" + path.toString().replace("\\", "/") + "\");";
    private static final Function<String, String> IMPORT_PACKAGE = pkg -> "importPackage(\"" + pkg + "\");";
    private static final Function<String, String> IMPORT_TYPE = type -> {
        String name = type.substring(type.lastIndexOf(46) + 1);
        return "var " + name + " = Java.type(\"" + type + "\")";
    };
    private final ScriptLoaderImpl loader;
    private final String name;
    private final Path path;
    private final ScriptLoader delegateLoader;
    private final ScriptLogger logger;
    private final CompositeAutoClosable compositeAutoClosable = CompositeAutoClosable.create();
    private final Set<Path> depends = new HashSet<Path>();

    public ScriptImpl(ScriptLoaderImpl loader, Path path) {
        this.loader = loader;
        String name = path.getFileName().toString();
        this.name = name.endsWith(".js") ? name.substring(0, name.length() - 3) : name;
        this.path = path;
        this.delegateLoader = new DelegateScriptLoader(loader);
        this.logger = ScriptLogger.create(loader.getEnvironment().getController().getLogger(), this);
        this.depends.add(this.path);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public ScriptLogger getLogger() {
        return this.logger;
    }

    @Override
    public CompositeAutoClosable getClosables() {
        return this.compositeAutoClosable;
    }

    @Override
    public void run() {
        try {
            Path loaderDirectory = this.loader.getEnvironment().getDirectory().normalize();
            ScriptEngine scriptEngine = this.loader.getEnvironment().getScriptEngine();
            BindingsBuilder bindings = BindingsBuilder.wrap(scriptEngine.createBindings());
            bindings.put("loader", this.delegateLoader).put("closableRegistry", this.compositeAutoClosable).put("exports", this.loader.getEnvironment().getExportRegistry()).put("logger", this.logger).put("cwd", this.path.normalize().toString().replace("\\", "/")).put("rsd", loaderDirectory.toString().replace("\\", "/") + "/").put("depend", this::depend);
            Set<BindingsSupplier> systemBindings = this.loader.getEnvironment().getSettings().getBindings();
            for (BindingsSupplier bindingsSupplier : systemBindings) {
                bindingsSupplier.supplyBindings(this, bindings);
            }
            SimpleScriptContext context = new SimpleScriptContext();
            context.setBindings(bindings.build(), 100);
            scriptEngine.eval(GLOBAL_SCRIPT_HEADER, (ScriptContext)context);
            for (String packageName : this.loader.getEnvironment().getSettings().getPackageImports()) {
                scriptEngine.eval(IMPORT_PACKAGE.apply(packageName), (ScriptContext)context);
            }
            for (String className : this.loader.getEnvironment().getSettings().getTypeImports()) {
                scriptEngine.eval(IMPORT_TYPE.apply(className), (ScriptContext)context);
            }
            Path path = loaderDirectory.resolve(this.path);
            scriptEngine.eval(LOAD_FUNCTION.apply(path), (ScriptContext)context);
        }
        catch (Throwable t) {
            this.logger.error("Exception occurred whilst loading script (" + this.path + ")");
            t.printStackTrace();
        }
    }

    @Override
    public Set<Path> getDependencies() {
        return Collections.unmodifiableSet(this.depends);
    }

    @Override
    public void depend(String path) {
        this.depend(Paths.get(path, new String[0]));
    }

    @Override
    public void depend(Path path) {
        if (this.path.equals(path)) {
            return;
        }
        this.depends.add(path);
    }

    @Override
    public void close() throws Exception {
        this.delegateLoader.close();
        this.compositeAutoClosable.close();
    }
}

