/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.plugin;

import javax.annotation.Nonnull;
import me.lucko.helper.maven.MavenLibrary;
import me.lucko.helper.plugin.ExtendedJavaPlugin;
import me.lucko.helper.sql.DatabaseCredentials;
import me.lucko.helper.sql.HelperDataSource;
import me.lucko.helper.sql.SqlProvider;
import me.lucko.helper.sql.plugin.HikariWrapper;
import me.lucko.helper.terminable.TerminableConsumer;
import org.bukkit.configuration.ConfigurationSection;

@MavenLibrary(groupId="org.slf4j", artifactId="slf4j-api", version="1.7.25")
public class SqlPlugin
extends ExtendedJavaPlugin
implements SqlProvider {
    private DatabaseCredentials globalCredentials;
    private HelperDataSource globalDataSource;

    protected void enable() {
        this.globalCredentials = DatabaseCredentials.fromConfig((ConfigurationSection)this.loadConfig("config.yml"));
        this.globalDataSource = this.getDataSource(this.globalCredentials);
        this.globalDataSource.bindWith((TerminableConsumer)this);
        this.provideService(SqlProvider.class, this);
        this.provideService(DatabaseCredentials.class, this.globalCredentials);
        this.provideService(HelperDataSource.class, this.globalDataSource);
    }

    @Override
    @Nonnull
    public HelperDataSource getDataSource() {
        return this.globalDataSource;
    }

    @Override
    @Nonnull
    public HelperDataSource getDataSource(@Nonnull DatabaseCredentials credentials) {
        return new HikariWrapper(credentials);
    }

    @Override
    @Nonnull
    public DatabaseCredentials getGlobalCredentials() {
        return this.globalCredentials;
    }
}

