/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.plugin;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import me.lucko.helper.sql.DatabaseCredentials;
import me.lucko.helper.sql.HelperDataSource;
import me.lucko.helper.sql.external.hikari.HikariConfig;
import me.lucko.helper.sql.external.hikari.HikariDataSource;

public class HikariWrapper
implements HelperDataSource {
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private final HikariDataSource hikari;

    public HikariWrapper(@Nonnull DatabaseCredentials credentials) {
        HikariConfig config = new HikariConfig();
        config.setMaximumPoolSize(25);
        config.setPoolName("helper-sql-" + COUNTER.getAndIncrement());
        config.setDataSourceClassName("me.lucko.helper.sql.external.mariadb.jdbc.MySQLDataSource");
        config.addDataSourceProperty("serverName", credentials.getAddress());
        config.addDataSourceProperty("port", credentials.getPort());
        config.addDataSourceProperty("databaseName", credentials.getDatabase());
        config.setUsername(credentials.getUsername());
        config.setPassword(credentials.getPassword());
        config.addDataSourceProperty("properties", "useUnicode=true;characterEncoding=utf8");
        config.setConnectionTimeout(TimeUnit.SECONDS.toMillis(15L));
        config.setLeakDetectionThreshold(TimeUnit.SECONDS.toMillis(10L));
        this.hikari = new HikariDataSource(config);
    }

    @Override
    @Nonnull
    public HikariDataSource getHikari() {
        return (HikariDataSource)Preconditions.checkNotNull((Object)this.hikari, (Object)"hikari");
    }

    @Override
    @Nonnull
    public Connection getConnection() throws SQLException {
        return (Connection)Preconditions.checkNotNull((Object)this.getHikari().getConnection(), (Object)"connection is null");
    }

    public void close() {
        if (this.hikari != null) {
            this.hikari.close();
        }
    }
}

