/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.util.exceptions;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientException;
import java.sql.SQLWarning;
import me.lucko.helper.sql.external.mariadb.jdbc.MariaDbConnection;
import me.lucko.helper.sql.external.mariadb.jdbc.MariaDbStatement;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.SqlStates;

public class ExceptionMapper {
    public static void throwException(SQLException exception, MariaDbConnection connection, MariaDbStatement statement) throws SQLException {
        throw ExceptionMapper.getException(exception, connection, statement, false);
    }

    public static SQLException connException(String message) {
        return ExceptionMapper.connException(message, null);
    }

    public static SQLException connException(String message, Throwable cause) {
        return ExceptionMapper.get(message, SqlStates.CONNECTION_EXCEPTION.getSqlState(), -1, cause, false);
    }

    public static SQLException getException(SQLException exception, MariaDbConnection connection, MariaDbStatement statement, boolean timeout) {
        SQLException sqlException;
        String message = exception.getMessage();
        if (connection != null) {
            message = "(conn=" + connection.getServerThreadId() + ") " + message;
        } else if (statement != null) {
            message = "(conn=" + statement.getServerThreadId() + ") " + message;
        }
        SqlStates state = null;
        if (exception.getSQLState() != null) {
            if (message.contains("\n")) {
                message = message.substring(0, message.indexOf("\n"));
            }
            sqlException = ExceptionMapper.get(message, exception.getSQLState(), exception.getErrorCode(), exception, timeout);
            String sqlState = exception.getSQLState();
            state = SqlStates.fromString(sqlState);
            SQLException nextException = exception.getNextException();
            if (nextException != null) {
                sqlException.setNextException(nextException);
            }
        } else {
            sqlException = exception;
        }
        if (connection != null) {
            if (SqlStates.CONNECTION_EXCEPTION.equals((Object)state)) {
                connection.setHostFailed();
                if (connection.pooledConnection != null) {
                    connection.pooledConnection.fireConnectionErrorOccured(sqlException);
                }
            } else if (connection.pooledConnection != null && statement != null) {
                connection.pooledConnection.fireStatementErrorOccured(statement, sqlException);
            }
        }
        return sqlException;
    }

    public static void checkConnectionException(SQLException exception, MariaDbConnection connection) {
        SqlStates state;
        if (exception.getSQLState() != null && SqlStates.CONNECTION_EXCEPTION.equals((Object)(state = SqlStates.fromString(exception.getSQLState())))) {
            connection.setHostFailed();
            if (connection.pooledConnection != null) {
                connection.pooledConnection.fireConnectionErrorOccured(exception);
            }
        }
    }

    public static SQLException get(String message, String sqlState, int errorCode, Throwable exception, boolean timeout) {
        SqlStates state = SqlStates.fromString(sqlState);
        switch (state) {
            case DATA_EXCEPTION: {
                return new SQLDataException(message, sqlState, errorCode, exception);
            }
            case FEATURE_NOT_SUPPORTED: {
                return new SQLFeatureNotSupportedException(message, sqlState, errorCode, exception);
            }
            case CONSTRAINT_VIOLATION: {
                return new SQLIntegrityConstraintViolationException(message, sqlState, errorCode, exception);
            }
            case INVALID_AUTHORIZATION: {
                return new SQLInvalidAuthorizationSpecException(message, sqlState, errorCode, exception);
            }
            case CONNECTION_EXCEPTION: {
                return new SQLNonTransientConnectionException(message, sqlState, errorCode, exception);
            }
            case SYNTAX_ERROR_ACCESS_RULE: {
                return new SQLSyntaxErrorException(message, sqlState, errorCode, exception);
            }
            case TRANSACTION_ROLLBACK: {
                return new SQLTransactionRollbackException(message, sqlState, errorCode, exception);
            }
            case WARNING: {
                return new SQLWarning(message, sqlState, errorCode, exception);
            }
            case INTERRUPTED_EXCEPTION: {
                if (timeout && "70100".equals(sqlState)) {
                    return new SQLTimeoutException(message, sqlState, errorCode, exception);
                }
                if (exception instanceof SQLNonTransientConnectionException) {
                    return new SQLNonTransientConnectionException(message, sqlState, errorCode, exception);
                }
                return new SQLTransientException(message, sqlState, errorCode, exception);
            }
            case TIMEOUT_EXCEPTION: {
                return new SQLTimeoutException(message, sqlState, errorCode, exception);
            }
            case UNDEFINED_SQLSTATE: {
                if (!(exception instanceof SQLNonTransientConnectionException)) break;
                return new SQLNonTransientConnectionException(message, sqlState, errorCode, exception);
            }
        }
        return new SQLException(message, sqlState, errorCode, exception);
    }

    public static SQLException getSqlException(String message, Exception exception) {
        return new SQLException(message, exception);
    }

    public static SQLException getSqlException(String message, String sqlState, Exception exception) {
        return new SQLException(message, sqlState, 0, exception);
    }

    public static SQLException getSqlException(String message) {
        return new SQLException(message);
    }

    public static SQLException getFeatureNotSupportedException(String message) {
        return new SQLFeatureNotSupportedException(message);
    }

    public static String mapCodeToSqlState(int code) {
        switch (code) {
            case 1022: {
                return "23000";
            }
            case 1037: {
                return "HY001";
            }
            case 1038: {
                return "HY001";
            }
            case 1040: {
                return "08004";
            }
            case 1042: {
                return "08S01";
            }
            case 1043: {
                return "08S01";
            }
            case 1044: {
                return "42000";
            }
            case 1045: {
                return "28000";
            }
            case 1047: {
                return "HY000";
            }
            case 1050: {
                return "42S01";
            }
            case 1051: {
                return "42S02";
            }
            case 1052: {
                return "23000";
            }
            case 1053: {
                return "08S01";
            }
            case 1054: {
                return "42S22";
            }
            case 1055: {
                return "42000";
            }
            case 1056: {
                return "42000";
            }
            case 1057: {
                return "42000";
            }
            case 1058: {
                return "21S01";
            }
            case 1059: {
                return "42000";
            }
            case 1060: {
                return "42S21";
            }
            case 1061: {
                return "42000";
            }
            case 1062: {
                return "23000";
            }
            case 1063: {
                return "42000";
            }
            case 1064: {
                return "42000";
            }
            case 1065: {
                return "42000";
            }
            case 1066: {
                return "42000";
            }
            case 1067: {
                return "42000";
            }
            case 1068: {
                return "42000";
            }
            case 1069: {
                return "42000";
            }
            case 1070: {
                return "42000";
            }
            case 1071: {
                return "42000";
            }
            case 1072: {
                return "42000";
            }
            case 1073: {
                return "42000";
            }
            case 1074: {
                return "42000";
            }
            case 1075: {
                return "42000";
            }
            case 1080: {
                return "08S01";
            }
            case 1081: {
                return "08S01";
            }
            case 1082: {
                return "42S12";
            }
            case 1083: {
                return "42000";
            }
            case 1084: {
                return "42000";
            }
            case 1090: {
                return "42000";
            }
            case 1091: {
                return "42000";
            }
            case 1101: {
                return "42000";
            }
            case 1102: {
                return "42000";
            }
            case 1103: {
                return "42000";
            }
            case 1104: {
                return "42000";
            }
            case 1106: {
                return "42000";
            }
            case 1107: {
                return "42000";
            }
            case 1109: {
                return "42S02";
            }
            case 1110: {
                return "42000";
            }
            case 1112: {
                return "42000";
            }
            case 1113: {
                return "42000";
            }
            case 1115: {
                return "42000";
            }
            case 1118: {
                return "42000";
            }
            case 1120: {
                return "42000";
            }
            case 1121: {
                return "42000";
            }
            case 1129: {
                return "HY000";
            }
            case 1130: {
                return "HY000";
            }
            case 1131: {
                return "42000";
            }
            case 1132: {
                return "42000";
            }
            case 1133: {
                return "42000";
            }
            case 1136: {
                return "21S01";
            }
            case 1138: {
                return "42000";
            }
            case 1139: {
                return "42000";
            }
            case 1140: {
                return "42000";
            }
            case 1141: {
                return "42000";
            }
            case 1142: {
                return "42000";
            }
            case 1143: {
                return "42000";
            }
            case 1144: {
                return "42000";
            }
            case 1145: {
                return "42000";
            }
            case 1146: {
                return "42S02";
            }
            case 1147: {
                return "42000";
            }
            case 1148: {
                return "42000";
            }
            case 1149: {
                return "42000";
            }
            case 1152: {
                return "08S01";
            }
            case 1153: {
                return "08S01";
            }
            case 1154: {
                return "08S01";
            }
            case 1155: {
                return "08S01";
            }
            case 1156: {
                return "08S01";
            }
            case 1157: {
                return "08S01";
            }
            case 1158: {
                return "08S01";
            }
            case 1159: {
                return "08S01";
            }
            case 1160: {
                return "08S01";
            }
            case 1161: {
                return "08S01";
            }
            case 1162: {
                return "42000";
            }
            case 1163: {
                return "42000";
            }
            case 1164: {
                return "42000";
            }
            case 1166: {
                return "42000";
            }
            case 1167: {
                return "42000";
            }
            case 1169: {
                return "23000";
            }
            case 1170: {
                return "42000";
            }
            case 1171: {
                return "42000";
            }
            case 1172: {
                return "42000";
            }
            case 1173: {
                return "42000";
            }
            case 1177: {
                return "42000";
            }
            case 1178: {
                return "42000";
            }
            case 1179: {
                return "25000";
            }
            case 1184: {
                return "08S01";
            }
            case 1189: {
                return "08S01";
            }
            case 1190: {
                return "08S01";
            }
            case 1203: {
                return "42000";
            }
            case 1205: {
                return "41000";
            }
            case 1207: {
                return "25000";
            }
            case 1211: {
                return "42000";
            }
            case 1213: {
                return "40001";
            }
            case 1216: {
                return "23000";
            }
            case 1217: {
                return "23000";
            }
            case 1218: {
                return "08S01";
            }
            case 1222: {
                return "21000";
            }
            case 1226: {
                return "42000";
            }
            case 1230: {
                return "42000";
            }
            case 1231: {
                return "42000";
            }
            case 1232: {
                return "42000";
            }
            case 1234: {
                return "42000";
            }
            case 1235: {
                return "42000";
            }
            case 1239: {
                return "42000";
            }
            case 1241: {
                return "21000";
            }
            case 1242: {
                return "21000";
            }
            case 1247: {
                return "42S22";
            }
            case 1248: {
                return "42000";
            }
            case 1249: {
                return "01000";
            }
            case 1250: {
                return "42000";
            }
            case 1251: {
                return "08004";
            }
            case 1252: {
                return "42000";
            }
            case 1253: {
                return "42000";
            }
            case 1261: {
                return "01000";
            }
            case 1262: {
                return "01000";
            }
            case 1263: {
                return "01000";
            }
            case 1264: {
                return "01000";
            }
            case 1265: {
                return "01000";
            }
            case 1280: {
                return "42000";
            }
            case 1281: {
                return "42000";
            }
            case 1286: {
                return "42000";
            }
        }
        return null;
    }
}

