/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.io;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.TraceObject;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.Utils;

public class LruTraceCache
extends LinkedHashMap<String, TraceObject> {
    private AtomicLong increment = new AtomicLong();

    public TraceObject put(TraceObject value) {
        String key = this.increment.incrementAndGet() + "- " + DateTimeFormatter.ISO_INSTANT.format(Instant.now());
        return this.put(key, value);
    }

    public LruTraceCache() {
        super(16, 1.0f, false);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, TraceObject> eldest) {
        return this.size() > 10;
    }

    public synchronized String printStack() {
        StringBuilder sb = new StringBuilder();
        Set set = this.entrySet();
        for (Map.Entry entry : set) {
            TraceObject traceObj = (TraceObject)entry.getValue();
            String key = (String)entry.getKey();
            String indicator = "";
            switch (traceObj.getIndicatorFlag()) {
                case 0: {
                    break;
                }
                case 2: {
                    indicator = " (compressed protocol - packet not compressed)";
                    break;
                }
                case 1: {
                    indicator = " (compressed protocol - packet compressed)";
                    break;
                }
            }
            if (traceObj.isSend()) {
                sb.append("\nsend at -exchange:");
            } else {
                sb.append("\nread at -exchange:");
            }
            sb.append(key).append(indicator).append(Utils.hexdump(traceObj.getBuf()));
            traceObj.remove();
        }
        this.clear();
        return sb.toString();
    }

    public synchronized void clearMemory() {
        Collection traceObjects = this.values();
        for (TraceObject traceObject : traceObjects) {
            traceObject.remove();
        }
        this.clear();
    }
}

